/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPriceCertificate
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "PriceCertificate";
    private String m_subjectKeyIdentifier;
    private double m_rate;
    private Timestamp m_signatureTime;
    private String m_biID;
    private String m_hashValue;
    private Document m_docThePriceCert;
    private static final String XML_ELEM_SUBJECT_KEY_IDENTIFIER = "SubjectKeyIdentifier";
    private static final String XML_ELEM_RATE = "Rate";
    private static final String XML_ELEM_SIG_TIME = "SignatureTime";
    private static final String XML_ELEM_BIID = "BiID";

    public XMLPriceCertificate(String subjectKeyIdentifier, double rate, Timestamp signatureTime, String biID) {
        this.m_subjectKeyIdentifier = subjectKeyIdentifier;
        this.m_signatureTime = signatureTime;
        this.m_rate = rate;
        this.m_biID = biID;
        this.m_docThePriceCert = XMLUtil.createDocument();
        this.m_docThePriceCert.appendChild(this.internal_toXmlElement(this.m_docThePriceCert));
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public XMLPriceCertificate(String subjectKeyIdentifier, double rate, String biID) {
        this.m_subjectKeyIdentifier = subjectKeyIdentifier;
        this.m_signatureTime = null;
        this.m_rate = rate;
        this.m_biID = biID;
        this.m_docThePriceCert = XMLUtil.createDocument();
        this.m_docThePriceCert.appendChild(this.internal_toXmlElement(this.m_docThePriceCert));
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public XMLPriceCertificate(String subjectKeyIdentifier, double rate, Timestamp signatureTime, String biID, String signatureXml) {
        this.m_subjectKeyIdentifier = subjectKeyIdentifier;
        this.m_signatureTime = signatureTime;
        this.m_rate = rate;
        this.m_biID = biID;
        this.m_docThePriceCert = XMLUtil.createDocument();
        this.m_docThePriceCert.appendChild(this.internal_toXmlElement(this.m_docThePriceCert));
        this.addSignatureNode(this.m_docThePriceCert, signatureXml);
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public void addSignature(String signatureXml) {
        this.addSignatureNode(this.m_docThePriceCert, signatureXml);
    }

    private void addSignatureNode(Document a_doc, String signatureXml) {
        Document signatureDoc = null;
        try {
            signatureDoc = XMLUtil.toXMLDocument(signatureXml);
            Element signatureElem = signatureDoc.getDocumentElement();
            XMLUtil.importNode(a_doc, signatureElem, true);
        }
        catch (Exception e) {
            LogHolder.log(7, LogType.PAY, "Could not parse signature node from string");
            LogHolder.log(7, LogType.PAY, e.getMessage());
        }
    }

    private Node internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute("version", "1.1");
        Element elem = a_doc.createElement(XML_ELEM_SUBJECT_KEY_IDENTIFIER);
        XMLUtil.setValue((Node)elem, this.m_subjectKeyIdentifier);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_RATE);
        NumberFormat twoDecDigits = NumberFormat.getInstance(Locale.ENGLISH);
        twoDecDigits.setMinimumFractionDigits(2);
        twoDecDigits.setMaximumFractionDigits(2);
        String rateString = twoDecDigits.format(this.m_rate);
        XMLUtil.setValue((Node)elem, rateString);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_SIG_TIME);
        String signatureTimeString = "";
        if (this.m_signatureTime != null) {
            signatureTimeString = this.m_signatureTime.toString();
        }
        XMLUtil.setValue((Node)elem, signatureTimeString);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_BIID);
        XMLUtil.setValue((Node)elem, this.m_biID);
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public XMLPriceCertificate(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docThePriceCert = doc;
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public XMLPriceCertificate(String xml, String hashValue, double rate) throws Exception {
        this(xml);
        this.m_rate = rate;
        this.m_hashValue = hashValue;
    }

    public XMLPriceCertificate(char[] xmldata) throws Exception {
        this(new String(xmldata));
    }

    public XMLPriceCertificate(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docThePriceCert = doc;
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public XMLPriceCertificate(Element xml) throws XMLParseException {
        this.setValues(xml);
        this.m_docThePriceCert = XMLUtil.createDocument();
        this.m_docThePriceCert.appendChild(XMLUtil.importNode(this.m_docThePriceCert, xml, true));
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public XMLPriceCertificate(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docThePriceCert = xml;
        this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
    }

    public boolean sign(IMyPrivateKey key) {
        try {
            XMLSignature theSignature = XMLSignature.sign((Node)this.m_docThePriceCert, key, 0);
            theSignature.clearCertificates();
            this.m_hashValue = XMLSignature.getHashValueOfElement(this.m_docThePriceCert);
            return true;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.PAY, "Error signing the certificate: ", e);
            return false;
        }
    }

    public boolean verify(PaymentInstanceDBEntry a_bi) {
        if (!SignatureVerifier.getInstance().isCheckSignatures(4)) {
            return true;
        }
        if (a_bi == null) {
            return false;
        }
        return XMLSignature.verifyFast((Node)this.m_docThePriceCert, a_bi.getCertPath().getEndEntityKeys());
    }

    private void setValues(Element xml) throws XMLParseException {
        String timestamp;
        XMLUtil.assertNodeName(xml, XML_ELEMENT_NAME);
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, XML_ELEM_SUBJECT_KEY_IDENTIFIER);
        XMLUtil.assertNotNull(elem);
        this.m_subjectKeyIdentifier = XMLUtil.parseValue((Node)elem, (String)null);
        if (this.m_subjectKeyIdentifier == null) {
            throw new XMLParseException(XML_ELEM_SUBJECT_KEY_IDENTIFIER);
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, XML_ELEM_RATE);
        this.m_rate = XMLUtil.parseValue((Node)elem, -9999.99);
        if (this.m_rate == -9999.99) {
            throw new XMLParseException(XML_ELEM_RATE);
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, XML_ELEM_SIG_TIME);
        if (elem != null && !(timestamp = XMLUtil.parseValue((Node)elem, "0")).equals("0")) {
            this.m_signatureTime = Timestamp.valueOf(timestamp);
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, XML_ELEM_BIID);
        this.m_biID = XMLUtil.parseValue((Node)elem, "unknown");
        if (this.m_biID.equals("unknown")) {
            throw new XMLParseException(XML_ELEM_BIID);
        }
    }

    public Timestamp getSignatureTime() {
        return this.m_signatureTime;
    }

    public double getRate() {
        return this.m_rate;
    }

    public String getSubjectKeyIdentifier() {
        return this.m_subjectKeyIdentifier;
    }

    public String getBiID() {
        return this.m_biID;
    }

    public String getHashValue() {
        return this.m_hashValue;
    }

    public Document getDocument() {
        return this.m_docThePriceCert;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            Element priceCertDocElem = this.m_docThePriceCert.getDocumentElement();
            return (Element)XMLUtil.importNode(a_doc, priceCertDocElem, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        String sig;
        String priceLabel = new String("Price: ");
        String price = XMLPriceCertificate.formatEuroCentValue(this.getRate());
        if (this.getSignatureTime() == null) {
            sig = "Not signed";
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
            sig = "Signed on : " + sdf.format(this.getSignatureTime());
        }
        return priceLabel + price + ", " + sig;
    }

    private static String formatEuroCentValue(double centvalue) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(centvalue) + " Eurocent";
    }
}

