/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos.integration;

import infoservice.agreement.paxos.PaxosInstance;
import infoservice.agreement.paxos.PaxosObject;
import infoservice.agreement.paxos.messages.PaxosMessage;
import java.util.Enumeration;
import java.util.Hashtable;

public class PaxosRejectManager
extends PaxosObject {
    private PaxosInstance m_paxosInstance;
    private Hashtable m_rejectMessages = new Hashtable();
    private Hashtable m_rejectCount = new Hashtable();

    public PaxosRejectManager(PaxosInstance a_paxosInstance) {
        this.m_paxosInstance = a_paxosInstance;
    }

    public boolean addRejectMessage(PaxosMessage a_msg) {
        if (a_msg == null || !a_msg.getMessageType().equals(PaxosMessage.REJECT)) {
            return false;
        }
        if (this.m_rejectMessages.get(a_msg.getSender()) == null) {
            this.m_rejectMessages.put(a_msg.getSender(), a_msg);
            Integer count = (Integer)this.m_rejectCount.get(a_msg.getProposal());
            if (count == null) {
                count = new Integer(0);
            }
            int newCount = count + 1;
            this.m_rejectCount.put(a_msg.getProposal(), new Integer(newCount));
            return true;
        }
        return false;
    }

    public int getRejectMessageCount() {
        return this.m_rejectMessages.size();
    }

    public boolean isMajorityPossible() {
        int needed = this.m_paxosInstance.getAcceptor().getQuorumTwoThird();
        int open = this.m_paxosInstance.getAcceptor().getN() - this.m_rejectMessages.size();
        Enumeration en = this.m_rejectCount.keys();
        while (en.hasMoreElements()) {
            String proposal = (String)en.nextElement();
            Integer count = (Integer)this.m_rejectCount.get(proposal);
            if (count + open < needed) continue;
            return true;
        }
        return false;
    }

    public String getMajorityReject() {
        Integer needed = new Integer(this.m_paxosInstance.getAcceptor().getQuorumTwoThird());
        Enumeration en = this.m_rejectCount.keys();
        while (en.hasMoreElements()) {
            String proposal = (String)en.nextElement();
            Integer count = (Integer)this.m_rejectCount.get(proposal);
            if (count.compareTo(needed) != 0 && count.compareTo(needed) != 1) continue;
            return proposal;
        }
        return null;
    }
}

