/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.apache.oro.text.DefaultMatchAction;
import org.apache.oro.text.MatchAction;
import org.apache.oro.text.MatchActionInfo;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public final class MatchActionProcessor {
    private Pattern __fieldSeparator = null;
    private PatternCompiler __compiler;
    private PatternMatcher __matcher;
    private Vector __patterns = new Vector();
    private Vector __actions = new Vector();
    private MatchAction __defaultAction = new DefaultMatchAction();

    public MatchActionProcessor(PatternCompiler compiler, PatternMatcher matcher) {
        this.__compiler = compiler;
        this.__matcher = matcher;
    }

    public MatchActionProcessor() {
        this(new Perl5Compiler(), new Perl5Matcher());
    }

    public void addAction(String pattern, int options, MatchAction action) throws MalformedPatternException {
        if (pattern != null) {
            this.__patterns.addElement(this.__compiler.compile(pattern, options));
        } else {
            this.__patterns.addElement(null);
        }
        this.__actions.addElement(action);
    }

    public void addAction(String pattern, int options) throws MalformedPatternException {
        this.addAction(pattern, options, this.__defaultAction);
    }

    public void addAction(String pattern) throws MalformedPatternException {
        this.addAction(pattern, 0);
    }

    public void addAction(String pattern, MatchAction action) throws MalformedPatternException {
        this.addAction(pattern, 0, action);
    }

    public void setFieldSeparator(String separator, int options) throws MalformedPatternException {
        if (separator == null) {
            this.__fieldSeparator = null;
            return;
        }
        this.__fieldSeparator = this.__compiler.compile(separator, options);
    }

    public void setFieldSeparator(String separator) throws MalformedPatternException {
        this.setFieldSeparator(separator, 0);
    }

    public void processMatches(InputStream input, OutputStream output, String encoding) throws IOException {
        this.processMatches(new InputStreamReader(input, encoding), new OutputStreamWriter(output));
    }

    public void processMatches(InputStream input, OutputStream output) throws IOException {
        this.processMatches(new InputStreamReader(input), new OutputStreamWriter(output));
    }

    public void processMatches(Reader input, Writer output) throws IOException {
        LineNumberReader reader = new LineNumberReader(input);
        PrintWriter writer = new PrintWriter(output);
        MatchActionInfo info = new MatchActionInfo();
        Vector fields = new Vector();
        info.matcher = this.__matcher;
        info.fieldSeparator = this.__fieldSeparator;
        info.input = reader;
        info.output = writer;
        info.fields = null;
        int patternCount = this.__patterns.size();
        info.lineNumber = 0;
        while ((info.line = reader.readLine()) != null) {
            info.charLine = info.line.toCharArray();
            int current = 0;
            while (current < patternCount) {
                MatchAction action;
                Object obj = this.__patterns.elementAt(current);
                if (obj != null) {
                    Pattern pattern = (Pattern)this.__patterns.elementAt(current);
                    if (this.__matcher.contains(info.charLine, pattern)) {
                        info.match = this.__matcher.getMatch();
                        info.lineNumber = reader.getLineNumber();
                        info.pattern = pattern;
                        if (this.__fieldSeparator != null) {
                            fields.removeAllElements();
                            Util.split(fields, this.__matcher, this.__fieldSeparator, info.line);
                            info.fields = fields;
                        } else {
                            info.fields = null;
                        }
                        action = (MatchAction)this.__actions.elementAt(current);
                        action.processMatch(info);
                    }
                } else {
                    info.match = null;
                    info.lineNumber = reader.getLineNumber();
                    if (this.__fieldSeparator != null) {
                        fields.removeAllElements();
                        Util.split(fields, this.__matcher, this.__fieldSeparator, info.line);
                        info.fields = fields;
                    } else {
                        info.fields = null;
                    }
                    action = (MatchAction)this.__actions.elementAt(current);
                    action.processMatch(info);
                }
                ++current;
            }
        }
        writer.flush();
        reader.close();
    }
}

