/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class TimedOutputStream
extends OutputStream {
    private OutputStream m_Out;
    private long m_TimeoutInTicks;
    private volatile long m_TimeOutTick;
    private volatile boolean m_bTimedOut;
    private static Thread ms_threadInterrupt;
    private static Hashtable ms_hashtableOutputStreams;
    private static volatile long ms_currentTick;
    static final long MS_PER_TICK = 5000L;

    private TimedOutputStream() {
    }

    public static void init() {
        ms_hashtableOutputStreams = new Hashtable(1000);
        ms_threadInterrupt = new Thread((Runnable)new TimedOutputStreamInterrupt(), "TimedOutputStream");
        ms_threadInterrupt.setDaemon(true);
        ms_threadInterrupt.start();
    }

    public TimedOutputStream(OutputStream parent, long msTimeout) {
        this.m_Out = parent;
        this.m_TimeoutInTicks = msTimeout / 5000L;
    }

    public void write(int b) throws IOException {
        this.m_TimeOutTick = ms_currentTick + this.m_TimeoutInTicks;
        ms_hashtableOutputStreams.put(this, this);
        this.m_bTimedOut = false;
        try {
            this.m_Out.write(b);
        }
        catch (IOException e) {
            ms_hashtableOutputStreams.remove(this);
            if (this.m_bTimedOut) {
                throw new InterruptedIOException("TimedOutputStream: write() timed out!");
            }
            throw e;
        }
        ms_hashtableOutputStreams.remove(this);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int i1, int i2) throws IOException {
        this.m_TimeOutTick = ms_currentTick + this.m_TimeoutInTicks;
        ms_hashtableOutputStreams.put(this, this);
        this.m_bTimedOut = false;
        try {
            this.m_Out.write(b, i1, i2);
        }
        catch (IOException e) {
            ms_hashtableOutputStreams.remove(this);
            if (this.m_bTimedOut) {
                throw new InterruptedIOException("TimedOutputStream: write() timed out!");
            }
            throw e;
        }
        ms_hashtableOutputStreams.remove(this);
    }

    public void close() throws IOException {
        this.m_Out.close();
    }

    public void flush() throws IOException {
        this.m_TimeOutTick = ms_currentTick + this.m_TimeoutInTicks;
        ms_hashtableOutputStreams.put(this, this);
        this.m_bTimedOut = false;
        try {
            this.m_Out.flush();
        }
        catch (IOException e) {
            ms_hashtableOutputStreams.remove(this);
            if (this.m_bTimedOut) {
                throw new InterruptedIOException("TimedOutputStream: flush() timed out!");
            }
            throw e;
        }
        ms_hashtableOutputStreams.remove(this);
    }

    private static final class TimedOutputStreamInterrupt
    implements Runnable {
        private TimedOutputStreamInterrupt() {
        }

        public void run() {
            ms_currentTick = 0L;
            block6: while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                ms_currentTick++;
                try {
                    Enumeration elements = ms_hashtableOutputStreams.elements();
                    while (true) {
                        if (!elements.hasMoreElements()) continue block6;
                        TimedOutputStream elem = (TimedOutputStream)elements.nextElement();
                        if (ms_currentTick <= elem.m_TimeOutTick) continue;
                        try {
                            elem.m_bTimedOut = true;
                            elem.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

