/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.pay.xml.XMLPassivePayment;
import anon.util.JAPMessages;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.JAPDialog;
import jap.JAPUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogType;

public class PassivePaymentDetails
extends JAPDialog
implements ActionListener {
    private static final String MSG_HEADING = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_heading";
    private static final String MSG_TITLE = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_title";
    private static final String MSG_CLOSEBUTTON = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_closebutton";
    private static final String MSG_UNKNOWN_PAYMENT = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_unknownpayment";
    private static final String MSG_NOT_SHOWN = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_notshown";
    private static final String MSG_PAID_BY = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_paidby";
    private static final String MSG_CREDITCARDWORD = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_creditcardword";
    private static final String MSG_CREDITCARDTYPE = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_creditcardtype";
    private static final String MSG_NUMBER = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_number";
    private static final String MSG_OWNER = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_owner";
    private static final String MSG_VALID = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_valid";
    private static final String MSG_CHECKNUMBER = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_checknumber";
    private static final String MSG_AMOUNT = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_amount";
    private static final String MSG_TRANSFERNUMBER = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_transfernumber";
    private static final String MSG_ACCOUNTNUMBER = (class$jap$pay$PassivePaymentDetails == null ? (class$jap$pay$PassivePaymentDetails = PassivePaymentDetails.class$("jap.pay.PassivePaymentDetails")) : class$jap$pay$PassivePaymentDetails).getName() + "_accountnumber";
    private GridBagConstraints m_c;
    private JButton m_closeButton;
    static /* synthetic */ Class class$jap$pay$PassivePaymentDetails;

    public PassivePaymentDetails(JAPDialog a_parent, XMLPassivePayment paymentToShow, long transfernumber, long accountnumber) {
        super(a_parent, JAPMessages.getString(MSG_TITLE));
        try {
            this.setDefaultCloseOperation(2);
            this.buildDialog(paymentToShow, transfernumber, accountnumber);
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.PAY, "Could not create PassivePaymentDetails: ", e);
        }
    }

    private void buildDialog(XMLPassivePayment pp, long transfernumber, long accountnumber) {
        this.m_c = new GridBagConstraints();
        this.m_c.anchor = 11;
        this.m_c.insets = new Insets(10, 30, 10, 30);
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weighty = 0.0;
        this.m_c.weightx = 0.0;
        this.getContentPane().setLayout(new GridBagLayout());
        JAPHtmlMultiLineLabel heading = new JAPHtmlMultiLineLabel("<h3>" + JAPMessages.getString(MSG_HEADING) + "</h3");
        this.getContentPane().add((Component)heading, this.m_c);
        ++this.m_c.gridy;
        JPanel transactionDetailsPanel = this.buildTransactionDetailsPanel(accountnumber, transfernumber, pp.getAmount());
        this.getContentPane().add((Component)transactionDetailsPanel, this.m_c);
        ++this.m_c.gridy;
        JPanel paymentDetailsPanel = this.buildPaymentDetailsPanel(pp);
        this.getContentPane().add((Component)paymentDetailsPanel, this.m_c);
        ++this.m_c.gridy;
        this.m_closeButton = new JButton(JAPMessages.getString(MSG_CLOSEBUTTON));
        this.m_closeButton.addActionListener(this);
        ++this.m_c.gridy;
        this.getContentPane().add((Component)this.m_closeButton, this.m_c);
    }

    private JPanel buildTransactionDetailsPanel(long accountnumber, long transfernumber, long amount) {
        JPanel transactionPanel = new JPanel();
        BoxLayout verticalBoxLayout = new BoxLayout(transactionPanel, 1);
        transactionPanel.setLayout(verticalBoxLayout);
        String accNum = new Long(accountnumber).toString();
        String accountDesignation = JAPMessages.getString(MSG_ACCOUNTNUMBER);
        JLabel accountLabel = new JLabel(accountDesignation + ": " + accNum);
        transactionPanel.add(accountLabel);
        String tan = new Long(transfernumber).toString();
        String tanDesignation = JAPMessages.getString(MSG_TRANSFERNUMBER);
        JLabel tanLabel = new JLabel(tanDesignation + ": " + tan);
        transactionPanel.add((Component)tanLabel, this.m_c);
        String amountString = JAPUtil.formatEuroCentValue(amount, true);
        String amountDesignation = JAPMessages.getString(MSG_AMOUNT);
        JLabel amountLabel = new JLabel(amountDesignation + ": " + amountString);
        transactionPanel.add((Component)amountLabel, this.m_c);
        transactionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        return transactionPanel;
    }

    private JPanel buildPaymentDetailsPanel(XMLPassivePayment pp) {
        JPanel paymentPanel = new JPanel();
        BoxLayout verticalBoxLayout = new BoxLayout(paymentPanel, 1);
        paymentPanel.setLayout(verticalBoxLayout);
        String paymentOptionUsed = pp.getPaymentName();
        if (paymentOptionUsed.equalsIgnoreCase("CreditCard")) {
            JLabel errorLabel = new JLabel(JAPMessages.getString(MSG_NOT_SHOWN));
            paymentPanel.add(errorLabel);
        } else if (!paymentOptionUsed.equalsIgnoreCase("Paysafecard")) {
            JLabel errorLabel = new JLabel(JAPMessages.getString(MSG_UNKNOWN_PAYMENT));
            paymentPanel.add(errorLabel);
        }
        paymentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        return paymentPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_closeButton) {
            this.setVisible(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

