/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.client.TrustModel;
import anon.error.AccountEmptyException;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.pay.AIControlChannel;
import anon.pay.IPaymentListener;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLErrorMessage;
import anon.util.IReturnRunnable;
import anon.util.JAPMessages;
import anon.util.JobQueue;
import anon.util.Util;
import anon.util.captcha.ICaptchaSender;
import anon.util.captcha.IImageEncodedCaptcha;
import gui.FlippingPanel;
import gui.GUIUtils;
import gui.JAPProgressBar;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import gui.dialog.SimpleWizardContentPane;
import gui.dialog.WorkerContentPane;
import jap.JAPConstants;
import jap.JAPController;
import jap.JAPModel;
import jap.JAPNewView;
import jap.pay.AccountSettingsPanel;
import jap.pay.ActivePaymentDetails;
import jap.pay.IPaymentDialogPresentator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import logging.LogHolder;
import logging.LogType;

public class PaymentMainPanel
extends FlippingPanel {
    public static final long WARNING_AMOUNT = 125000000L;
    public static final long WARNING_TIME = 604800000L;
    public static final long FULL_AMOUNT = 500000000L;
    private static final String MSG_TITLE = AccountSettingsPanel.MSG_ACCOUNT_FLAT_VOLUME;
    private static final String MSG_LASTUPDATE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_lastupdate";
    private static final String MSG_PAYMENTNOTACTIVE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_paymentnotactive";
    private static final String MSG_NEARLYEMPTY_CREATE_ACCOUNT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_nearlyEmptyCreateAccount";
    private static final String MSG_NEARLYEXPIRED_CREATE_ACCOUNT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_nearlyExpiredCreateAccount";
    private static final String MSG_SESSIONSPENT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_sessionspent";
    private static final String MSG_TOTALSPENT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_totalspent";
    private static final String MSG_NO_ACTIVE_ACCOUNT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_noActiveAccount";
    private static final String MSG_ENABLE_AUTO_SWITCH = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_enableAutoSwitch";
    private static final String MSG_WITH_COSTS = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_withCosts";
    private static final String MSG_CREATE_ACCOUNT_TITLE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_createAccountTitle";
    private static final String MSG_CHOOSE_FREE_SERVICES_ONLY = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_chooseFreeServicesOnly";
    private static final String MSG_EXPERIMENTAL = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_experimental";
    private static final String MSG_TITLE_FLAT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_title_flat";
    private static final String MSG_VALID_UNTIL = AccountSettingsPanel.MSG_ACCOUNT_VALID;
    private static final String MSG_EURO_BALANCE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_euro_balance";
    private static final String MSG_NO_FLATRATE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_no_flatrate";
    private static final String MSG_WANNA_CHARGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_wannaCharge";
    private static final String MSG_TT_CREATE_ACCOUNT = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_ttCreateAccount";
    private static final String MSG_FREE_OF_CHARGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_freeOfCharge";
    private static final String MSG_OPEN_TRANSACTION = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_openTransaction";
    private static final String MSG_CREATE_ACCOUNT_QUESTION = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_createAccountQuestion";
    private static final String MSG_MAYBE_LATER = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + "_maybeLater";
    public static final String MSG_MONTHLY_RATE_USED = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".monthlyRateUsed";
    public static final String MSG_MONTHLY_RATE_USED_TITLE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".monthlyRateUsedTitle";
    public static final String MSG_MONTHLY_RATE_ALMOST_USED = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".monthlyRateAlmostUsed";
    public static final String MSG_MONTHLY_RATE_OVERUSAGE_EXPLAIN = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".monthlyRateOverusage";
    public static final String MSG_LBL_MONTHLY_AVAILABLE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".lblMonthlyAvailable";
    public static final String MSG_BTN_ADDITIONAL_RATE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".btnAdditionalRate";
    public static final String MSG_ALTERNATIVE_ADDITIONAL_RATE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".alternativeBuyAdditionalRate";
    private static final String MSG_TEST_PREMIUM_BETA = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".testPremiumBeta";
    public static final String MSG_ACCOUNT_BLOCKED_TOOLTIP = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".accountBlockedTooltip";
    public static final String MSG_ACCOUNT_BLOCKED = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".accountBlocked";
    public static final String MSG_HINT_AUTO_BALANCE_UPDATES = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".hintAutoBalanceUpdates";
    public static final String MSG_WEIRD_ACCONT_STATUS = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".weirdAccountStatus";
    private static final String MSG_TITLE_USE_MONTHLY_VOLUME_PREMATURELY = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".titleUseMonthlyVolumePrematurely";
    private static final String MSG_CBX_ACCEPT_OVERUSAGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".cbxAcceptOverusage";
    private static final String MSG_HINT_ACCEPT_OVERUSAGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".hintAcceptOverusage";
    private static final String MSG_WAIT_REQUESTING_DATA_VOLUME = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".waitRequestingDataVolume";
    private static final String MSG_SUCCESS_OVERUSAGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".successOverusage";
    private static final String MSG_FAILED_OVERUSAGE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".failedOverusage";
    private static final String MSG_FAILED_OVERUSAGE_NO_CONNECTION = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".failedOverusageNoConnection";
    private static final String MSG_FAILED_OVERUSAGE_NOT_SYNCHRONIZED = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".failedOverusageNotSynchronized";
    private static final String MSG_FAILED_OVERUSAGE_DOUBLE = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".failedOverusageDouble";
    private static final String MSG_BLOCKED_REASONS = (class$jap$pay$PaymentMainPanel == null ? (class$jap$pay$PaymentMainPanel = PaymentMainPanel.class$("jap.pay.PaymentMainPanel")) : class$jap$pay$PaymentMainPanel).getName() + ".blockedReasons";
    private static final String[] MSG_PAYMENT_ERRORS = new String[]{"_xmlSuccess", "_xmlErrorInternal", "_xmlErrorWrongFormat", "_xmlErrorWrongData", "_xmlErrorKeyNotFound", "_xmlErrorBadSignature", "_xmlErrorBadRequest", "_xmlErrorNoAccountCert", "_xmlErrorNoBalance", "_xmlErrorNoConfirmation", "_accountempty", "_xmlErrorCascadeLength", "_xmlErrorDatabase", "_xmlErrorInsufficientBalance", "_xmlErrorNoFlatrateOffered", "_xmlErrorInvalidCode", "_xmlErrorInvalidCC", "_xmlErrorInvalidPriceCerts", "_xmlErrorMultipleLogin", "_xmlErrorNoRecordFound", "_xmlErrorPartialSuccess", "_xmlErrorAccountBlocked"};
    private ImageIcon[] m_accountIcons;
    private JAPProgressBar m_BalanceProgressBar;
    private JAPProgressBar m_BalanceSmallProgressBar;
    private JButton m_btnCreateAccount;
    private JLabel m_BalanceText;
    private JLabel m_BalanceTextSmall;
    private JobQueue m_queueUpdate;
    private JLabel m_dateLabel;
    private JAPNewView m_view;
    private MyPaymentListener m_MyPaymentListener = new MyPaymentListener();
    private boolean m_notifiedEmpty = false;
    private boolean m_bShowingError = false;
    private Object SYNC_SHOW_ERROR = new Object();
    private JLabel m_labelTotalSpent;
    private JLabel m_labelSessionSpent;
    private JLabel m_labelTitle;
    private JLabel m_labelTitleSmall;
    private JLabel m_labelTotalSpentHeader;
    private JLabel m_labelSessionSpentHeader;
    private JLabel m_labelValidUntilHeader;
    private JLabel m_labelValidUntil;
    private JLabel m_labelMonthlyAvailableHeader;
    private JLabel m_labelMonthlyAvailable;
    private JButton m_btnDetails;
    private long m_spentThisSession;
    static /* synthetic */ Class class$jap$pay$PaymentMainPanel;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public PaymentMainPanel(JAPNewView view, final JLabel a_alignLabel) {
        super(view, true);
        this.m_view = view;
        this.m_queueUpdate = new JobQueue("Payment Panel Update");
        this.loadIcons();
        JPanel fullPanel = new JPanel();
        fullPanel.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        this.m_labelTitle = new JLabel(JAPMessages.getString(MSG_TITLE) + ":");
        c1.insets = new Insets(0, 5, 0, 0);
        c1.anchor = 17;
        c1.weightx = 0.0;
        c1.fill = 2;
        fullPanel.add((Component)this.m_labelTitle, c1);
        JPanel spacer = new JPanel();
        Dimension spacerDimension = new Dimension(this.m_labelTitle.getFontMetrics(this.m_labelTitle.getFont()).charWidth('9') * 6, 1);
        spacer.setPreferredSize(spacerDimension);
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridx = 1;
        c1.fill = 0;
        c1.weightx = 1.0;
        fullPanel.add((Component)spacer, c1);
        this.m_BalanceText = new JLabel(" ");
        this.m_BalanceText.setHorizontalAlignment(4);
        c1.insets = new Insets(0, 5, 0, 0);
        c1.weightx = 0.0;
        c1.fill = 2;
        c1.gridx = 2;
        fullPanel.add((Component)this.m_BalanceText, c1);
        JLabel label = new JLabel("", 4){

            public Dimension getPreferredSize() {
                return a_alignLabel.getPreferredSize();
            }
        };
        c1.weightx = 0.0;
        c1.fill = 2;
        c1.gridx = 3;
        c1.insets = new Insets(0, 10, 0, 0);
        fullPanel.add((Component)label, c1);
        this.m_BalanceProgressBar = new JAPProgressBar();
        this.m_BalanceProgressBar.setMinimum(0);
        this.m_BalanceProgressBar.setMaximum(6);
        this.m_BalanceProgressBar.setBorderPainted(false);
        c1.gridx = 4;
        c1.weightx = 0.0;
        c1.fill = 0;
        c1.insets = new Insets(0, 5, 0, 0);
        this.m_btnDetails = new JButton(JAPMessages.getString(ActivePaymentDetails.MSG_PAYBUTTON));
        this.m_btnDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                String piid = JAPController.getInstance().getCurrentMixCascade().getPIID();
                if (piid == null || piid.trim().length() == 0) {
                    PaymentMainPanel.this.m_view.showPaymentDialog(null);
                } else {
                    PaymentMainPanel.this.m_view.showPaymentDialog(piid);
                }
            }
        });
        fullPanel.add(this.m_btnDetails);
        this.m_labelValidUntilHeader = new JLabel(JAPMessages.getString(MSG_VALID_UNTIL));
        c1.insets = new Insets(10, 20, 0, 0);
        c1.gridx = 0;
        c1.gridy = 1;
        c1.anchor = 17;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelValidUntilHeader, c1);
        spacer = new JPanel();
        spacer.setPreferredSize(spacerDimension);
        c1.gridx = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.weightx = 1.0;
        c1.fill = 0;
        fullPanel.add((Component)spacer, c1);
        this.m_labelValidUntil = new JLabel(" ");
        this.m_labelValidUntil.setHorizontalAlignment(4);
        c1.insets = new Insets(10, 5, 0, 0);
        c1.gridx = 2;
        c1.fill = 2;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelValidUntil, c1);
        this.m_labelSessionSpentHeader = new JLabel(JAPMessages.getString(MSG_SESSIONSPENT));
        this.m_labelSessionSpentHeader.setVisible(false);
        c1.insets = new Insets(10, 20, 0, 0);
        c1.gridx = 0;
        c1.gridy = 3;
        c1.anchor = 17;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelSessionSpentHeader, c1);
        spacer = new JPanel();
        spacer.setPreferredSize(spacerDimension);
        c1.gridx = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.weightx = 1.0;
        c1.fill = 0;
        fullPanel.add((Component)spacer, c1);
        this.m_labelSessionSpent = new JLabel(" ");
        this.m_labelSessionSpent.setVisible(false);
        this.m_labelSessionSpent.setHorizontalAlignment(4);
        c1.insets = new Insets(10, 5, 0, 0);
        c1.gridx = 2;
        c1.fill = 2;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelSessionSpent, c1);
        this.m_labelTotalSpentHeader = new JLabel(JAPMessages.getString(MSG_TOTALSPENT));
        c1.insets = new Insets(10, 20, 0, 0);
        c1.gridx = 0;
        c1.gridy = 4;
        c1.anchor = 17;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelTotalSpentHeader, c1);
        spacer = new JPanel();
        spacer.setPreferredSize(spacerDimension);
        c1.gridx = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.weightx = 1.0;
        c1.fill = 0;
        fullPanel.add((Component)spacer, c1);
        this.m_labelTotalSpent = new JLabel(" ");
        this.m_labelTotalSpent.setHorizontalAlignment(4);
        c1.insets = new Insets(10, 5, 0, 0);
        c1.gridx = 2;
        c1.fill = 2;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelTotalSpent, c1);
        this.m_labelMonthlyAvailableHeader = new JLabel(JAPMessages.getString(MSG_LBL_MONTHLY_AVAILABLE));
        c1.insets = new Insets(10, 20, 0, 0);
        c1.gridx = 0;
        ++c1.gridy;
        c1.anchor = 17;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelMonthlyAvailableHeader, c1);
        spacer = new JPanel();
        spacer.setPreferredSize(spacerDimension);
        c1.gridx = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.weightx = 1.0;
        c1.fill = 0;
        fullPanel.add((Component)spacer, c1);
        this.m_labelMonthlyAvailable = new JLabel(" ");
        this.m_labelMonthlyAvailable.setHorizontalAlignment(4);
        c1.insets = new Insets(10, 5, 0, 0);
        c1.gridx = 2;
        c1.fill = 2;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_labelMonthlyAvailable, c1);
        this.m_dateLabel = new JLabel(JAPMessages.getString(MSG_LASTUPDATE));
        this.m_dateLabel.setVisible(false);
        c1.insets = new Insets(10, 20, 0, 0);
        c1.gridx = 0;
        ++c1.gridy;
        c1.anchor = 17;
        c1.weightx = 0.0;
        fullPanel.add((Component)this.m_dateLabel, c1);
        spacer = new JPanel();
        spacer.setPreferredSize(spacerDimension);
        c1.gridx = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.weightx = 1.0;
        c1.fill = 0;
        fullPanel.add((Component)spacer, c1);
        this.setFullPanel(fullPanel);
        JPanel smallPanel = new JPanel();
        smallPanel.setLayout(new GridBagLayout());
        c1 = new GridBagConstraints();
        this.m_labelTitleSmall = new JLabel(JAPMessages.getString(MSG_TITLE) + ":");
        c1.insets = new Insets(0, 5, 0, 0);
        c1.anchor = 17;
        c1.weightx = 0.0;
        c1.fill = 2;
        smallPanel.add((Component)this.m_labelTitleSmall, c1);
        spacer = new JPanel();
        spacerDimension = new Dimension(label.getFontMetrics(label.getFont()).charWidth('9') * 6, 1);
        spacer.setPreferredSize(spacerDimension);
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridx = 1;
        c1.fill = 0;
        c1.weightx = 1.0;
        smallPanel.add((Component)spacer, c1);
        c1.insets = new Insets(0, 5, 0, 0);
        c1.weightx = 0.0;
        c1.fill = 2;
        c1.gridx = 2;
        this.m_BalanceTextSmall = new JLabel(" ");
        this.m_BalanceTextSmall.setHorizontalAlignment(4);
        this.m_btnCreateAccount = new JButton(JAPMessages.getString(AccountSettingsPanel.MSG_ACCOUNTCREATE) + "...");
        this.m_btnCreateAccount.setToolTipText(JAPMessages.getString(MSG_TT_CREATE_ACCOUNT));
        smallPanel.add((Component)this.m_BalanceTextSmall, c1);
        this.m_btnCreateAccount.setVisible(false);
        this.m_BalanceSmallProgressBar = new JAPProgressBar();
        this.m_BalanceSmallProgressBar.setMinimum(0);
        this.m_BalanceSmallProgressBar.setMaximum(6);
        this.m_BalanceSmallProgressBar.setBorderPainted(false);
        label = new JLabel("", 4){

            public Dimension getPreferredSize() {
                Dimension size = new Dimension(a_alignLabel.getPreferredSize().width + (((PaymentMainPanel)PaymentMainPanel.this).m_BalanceSmallProgressBar.getPreferredSize().width - ((PaymentMainPanel)PaymentMainPanel.this).m_btnDetails.getPreferredSize().width), a_alignLabel.getPreferredSize().height);
                return size;
            }
        };
        c1.weightx = 0.0;
        c1.fill = 2;
        c1.gridx = 3;
        c1.insets = new Insets(0, 10, 0, 0);
        smallPanel.add((Component)label, c1);
        c1.gridx = 4;
        c1.weightx = 0.0;
        c1.fill = 0;
        c1.insets = new Insets(0, 5, 0, 0);
        smallPanel.add((Component)this.m_btnDetails, c1);
        this.setSmallPanel(smallPanel);
        MouseAdapter adapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (a_event.getSource() == PaymentMainPanel.this.m_btnCreateAccount) {
                    String piid = JAPController.getInstance().getCurrentMixCascade().getPIID();
                    if (piid == null || piid.trim().length() == 0) {
                        PaymentMainPanel.this.m_view.showPaymentDialog(null);
                    } else {
                        PaymentMainPanel.this.m_view.showPaymentDialog(piid);
                    }
                    return;
                }
                String tooltip = ((JLabel)a_event.getSource()).getToolTipText();
                if (tooltip != null && tooltip.equals(JAPMessages.getString(AccountSettingsPanel.MSG_BILLING_ERROR_TOOLTIP))) {
                    PayAccount account = PayAccountsFile.getInstance().getActiveAccount();
                    if (account != null) {
                        XMLBalance balance = account.getBalance();
                        if (balance != null && balance.getStartDate().after(new Timestamp(System.currentTimeMillis()))) {
                            JAPDialog.showWarningDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(AccountSettingsPanel.MSG_WRONG_TIME_TOO_EARLY, new String[]{"" + account.getAccountNumber(), Util.formatTimestamp(balance.getStartDate(), false), Util.formatTimestamp(new Date(), false)}));
                        } else {
                            String pi = "";
                            if (account.getBI() != null) {
                                pi = account.getBI().getName();
                            }
                            JAPDialog.LinkedInformation adapter = new JAPDialog.LinkedInformation("payment@jondos.de");
                            JAPDialog.showWarningDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(AccountSettingsPanel.MSG_BILLING_ERROR_EXPLAIN, new String[]{pi, "" + Util.formatBytesValueWithUnit(account.getCurrentCreditCalculated() - account.getCurrentCreditFromBalance(), 2), "" + account.getAccountNumber()}), (JAPDialog.ILinkedInformation)adapter);
                        }
                    }
                } else if (tooltip != null && tooltip.equals(JAPMessages.getString(MSG_ACCOUNT_BLOCKED_TOOLTIP))) {
                    PaymentMainPanel.showAccountBlockedDialog(PayAccountsFile.getInstance().getActiveAccount(), JAPController.getInstance().getCurrentView());
                } else if (((JLabel)a_event.getSource()).getCursor() != Cursor.getDefaultCursor()) {
                    if (((JLabel)a_event.getSource()).getName() != null && ((JLabel)a_event.getSource()).getName().equals("Transaction")) {
                        PaymentMainPanel.this.m_view.showConfigDialog("PAYMENT_TAB", PayAccountsFile.getInstance().getActiveAccount());
                    } else {
                        PayAccount account = PayAccountsFile.getInstance().getActiveAccount();
                        if (account != null && account.canDoMonthlyOverusage(new Timestamp(System.currentTimeMillis()))) {
                            PaymentMainPanel.showMonthlyOverusageQuestion(account, JAPController.getInstance().getCurrentView(), true, PaymentMainPanel.this.m_view);
                        } else {
                            String piid = JAPController.getInstance().getCurrentMixCascade().getPIID();
                            if (account != null) {
                                PaymentMainPanel.this.m_view.showPaymentDialog(account.getPIID());
                            } else if (piid == null || piid.trim().length() == 0) {
                                PaymentMainPanel.this.m_view.showPaymentDialog(null);
                            } else {
                                PaymentMainPanel.this.m_view.showPaymentDialog(piid);
                            }
                        }
                    }
                }
            }
        };
        this.m_BalanceTextSmall.addMouseListener(adapter);
        this.m_BalanceText.addMouseListener(adapter);
        this.m_btnCreateAccount.addMouseListener(adapter);
        PayAccountsFile.getInstance().addPaymentListener(this.m_MyPaymentListener);
        this.updateDisplay(PayAccountsFile.getInstance().getActiveAccount(), false);
    }

    public static void showAccountBlockedDialog(PayAccount a_account, Component a_parent) {
        XMLErrorMessage error = new XMLErrorMessage(21, a_account);
        JAPDialog.showErrorDialog(a_parent, PaymentMainPanel.translateBIError(error), (JAPDialog.ILinkedInformation)PaymentMainPanel.translateBIErrorAdapter(error, false));
    }

    public static JAPDialog.LinkedInformationAdapter translateBIErrorAdapter(XMLErrorMessage a_msg, final boolean a_bOnTop) {
        if (a_msg.getXmlErrorCode() == 21) {
            return new JAPDialog.AbstractLinkedURLAdapter("premium"){

                public boolean isOnTop() {
                    return a_bOnTop;
                }

                public URL getUrl() {
                    try {
                        return new URL("mailto:payment@jondos.de");
                    }
                    catch (MalformedURLException e) {
                        LogHolder.log(3, LogType.GUI, e);
                        return null;
                    }
                }
            };
        }
        return new JAPDialog.LinkedInformationAdapter(){

            public boolean isOnTop() {
                return a_bOnTop;
            }
        };
    }

    public static String translateBIError(XMLErrorMessage a_msg) {
        String error = "";
        if (a_msg.getXmlErrorCode() >= 0 && a_msg.getXmlErrorCode() < MSG_PAYMENT_ERRORS.length) {
            String strAddedMessage = "";
            if (a_msg.getXmlErrorCode() == 21) {
                strAddedMessage = JAPMessages.getString(MSG_BLOCKED_REASONS) + "<br/><br/>";
            }
            error = error + JAPMessages.getString(MSG_PAYMENT_ERRORS[a_msg.getXmlErrorCode()], new String[]{"" + a_msg.getAccountNumber(), strAddedMessage});
        } else {
            error = error + a_msg.getMessage();
        }
        return error;
    }

    public boolean isShowingError() {
        return this.m_bShowingError;
    }

    public void stopUpdateQueue() {
        this.m_queueUpdate.stop();
    }

    private void updateDisplay(final PayAccount activeAccount, final boolean a_bWarnIfNearlyEmpty) {
        if (PayAccountsFile.getInstance().getActiveAccount() != activeAccount) {
            return;
        }
        JobQueue.Job job = new JobQueue.Job(true){

            public void runJob() {
                if (activeAccount == null) {
                    PaymentMainPanel.this.m_labelValidUntil.setText("");
                    PaymentMainPanel.this.m_BalanceText.setVisible(false);
                    PaymentMainPanel.this.m_btnCreateAccount.setVisible(true);
                    PaymentMainPanel.this.m_BalanceText.setIcon(null);
                    PaymentMainPanel.this.m_BalanceText.setText(JAPMessages.getString(AccountSettingsPanel.MSG_ACCOUNTCREATE) + "...");
                    PaymentMainPanel.this.m_BalanceText.setForeground(PaymentMainPanel.this.m_labelValidUntil.getForeground());
                    PaymentMainPanel.this.m_BalanceProgressBar.setValue(0);
                    PaymentMainPanel.this.m_BalanceProgressBar.setEnabled(false);
                    PaymentMainPanel.this.m_spentThisSession = 0L;
                    PaymentMainPanel.this.m_labelSessionSpent.setText("");
                    PaymentMainPanel.this.m_labelTotalSpent.setText("");
                    PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                    PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                } else {
                    PaymentMainPanel.this.m_btnCreateAccount.setVisible(false);
                    PaymentMainPanel.this.m_BalanceText.setVisible(true);
                    final XMLBalance balance = activeAccount.getBalance();
                    final Timestamp now = new Timestamp(System.currentTimeMillis());
                    GregorianCalendar calendarEnd = null;
                    GregorianCalendar calendarNow = null;
                    Timestamp enddate = null;
                    if (balance != null) {
                        enddate = balance.getFlatEnddate();
                        calendarEnd = new GregorianCalendar();
                        calendarNow = new GregorianCalendar();
                        calendarEnd.setTime(enddate);
                    }
                    if (balance != null && activeAccount.isCharged(now)) {
                        PaymentMainPanel.this.m_BalanceProgressBar.setEnabled(false);
                        PaymentMainPanel.this.m_BalanceText.setText(Util.formatBytesValueWithUnit(activeAccount.getCurrentCredit(), 2));
                        PaymentMainPanel.this.m_BalanceText.setForeground(PaymentMainPanel.this.m_labelValidUntil.getForeground());
                        PaymentMainPanel.this.m_BalanceText.setIcon(null);
                        if (activeAccount.isAccountInfoUpdated() && activeAccount.getCurrentCreditCalculated() > activeAccount.getCurrentCreditFromBalance() + 40000000L || activeAccount.hasExpired(now) && balance.getStartDate().after(now)) {
                            PaymentMainPanel.this.m_BalanceText.setIcon(GUIUtils.loadImageIcon("warning.gif"));
                            PaymentMainPanel.this.m_BalanceText.setCursor(Cursor.getPredefinedCursor(12));
                            PaymentMainPanel.this.m_BalanceText.setToolTipText(JAPMessages.getString(AccountSettingsPanel.MSG_BILLING_ERROR_TOOLTIP));
                        } else if (activeAccount.isBlocked()) {
                            PaymentMainPanel.this.m_BalanceText.setIcon(GUIUtils.loadImageIcon("warning.gif"));
                            PaymentMainPanel.this.m_BalanceText.setCursor(Cursor.getPredefinedCursor(12));
                            PaymentMainPanel.this.m_BalanceText.setToolTipText(JAPMessages.getString(MSG_ACCOUNT_BLOCKED_TOOLTIP));
                        } else {
                            PaymentMainPanel.this.m_BalanceText.setIcon(null);
                            PaymentMainPanel.this.m_BalanceText.setCursor(Cursor.getDefaultCursor());
                            PaymentMainPanel.this.m_BalanceText.setToolTipText(null);
                        }
                        PaymentMainPanel.this.m_labelValidUntil.setText(Util.formatTimestamp(balance.getFlatEnddate(), false));
                        long deposit = 500000000L;
                        long credit = activeAccount.getCurrentCredit();
                        double percent = (double)credit / (double)deposit;
                        if (percent > 0.86) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(6);
                        } else if (percent > 0.71) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(5);
                        } else if (percent > 0.57) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(4);
                        } else if (percent > 0.43) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(3);
                        } else if (percent > 0.29) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(2);
                        } else if ((double)credit > 0.14) {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(1);
                        } else {
                            PaymentMainPanel.this.m_BalanceProgressBar.setValue(0);
                        }
                        PaymentMainPanel.this.m_BalanceProgressBar.setEnabled(true);
                        if (balance.getVolumeBytesMonthly() > 0L) {
                            PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(true);
                            PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(true);
                            PaymentMainPanel.this.m_labelMonthlyAvailable.setText(Util.formatBytesValueWithUnit(balance.getVolumeBytesMonthly(), 2));
                        } else {
                            PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                            PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                        }
                    } else {
                        PaymentMainPanel.this.m_BalanceText.setIcon(null);
                        PaymentMainPanel.this.m_BalanceProgressBar.setValue(0);
                        PaymentMainPanel.this.m_BalanceProgressBar.setEnabled(false);
                        if (balance == null) {
                            PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                            PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                            PaymentMainPanel.this.m_labelValidUntil.setText("");
                            PaymentMainPanel.this.m_BalanceText.setCursor(Cursor.getDefaultCursor());
                            PaymentMainPanel.this.m_BalanceText.setToolTipText(null);
                            PaymentMainPanel.this.m_BalanceText.setIcon(null);
                            PaymentMainPanel.this.m_BalanceText.setText(Util.formatBytesValueWithUnit(0L, 2));
                            PaymentMainPanel.this.m_BalanceText.setForeground(PaymentMainPanel.this.m_labelValidUntil.getForeground());
                        } else {
                            String endDateString = Util.formatTimestamp(enddate, false);
                            boolean expired = false;
                            PaymentMainPanel.this.m_BalanceText.setCursor(Cursor.getPredefinedCursor(12));
                            PaymentMainPanel.this.m_BalanceText.setForeground(Color.blue);
                            PaymentMainPanel.this.m_BalanceText.setIcon(GUIUtils.loadImageIcon("info.png"));
                            PaymentMainPanel.this.m_BalanceText.setToolTipText(JAPMessages.getString(MSG_TT_CREATE_ACCOUNT));
                            if (activeAccount.getCurrentCredit() == 0L && (balance.getVolumeBytesMonthly() == 0L || calendarEnd.get(2) == calendarNow.get(2))) {
                                PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                                PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                                PaymentMainPanel.this.m_labelValidUntil.setText("");
                            } else if (enddate != null && enddate.after(now)) {
                                if (balance.getVolumeBytesMonthly() > 0L) {
                                    PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(true);
                                    PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(true);
                                    PaymentMainPanel.this.m_labelMonthlyAvailable.setText(Util.formatBytesValueWithUnit(balance.getVolumeBytesMonthly(), 2));
                                } else {
                                    PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                                    PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                                }
                                PaymentMainPanel.this.m_labelValidUntil.setText(endDateString);
                            } else {
                                PaymentMainPanel.this.m_labelMonthlyAvailableHeader.setVisible(false);
                                PaymentMainPanel.this.m_labelMonthlyAvailable.setVisible(false);
                                expired = true;
                                PaymentMainPanel.this.m_labelValidUntil.setText(JAPMessages.getString(AccountSettingsPanel.MSG_EXPIRED));
                            }
                            if (activeAccount.getCurrentBytes() > 0L && expired) {
                                PaymentMainPanel.this.m_BalanceText.setText(JAPMessages.getString(AccountSettingsPanel.MSG_EXPIRED));
                            } else if (!expired && !activeAccount.isUsed()) {
                                if (!activeAccount.isTransactionExpired()) {
                                    PaymentMainPanel.this.m_BalanceText.setText(JAPMessages.getString(AccountSettingsPanel.MSG_NO_TRANSACTION));
                                    PaymentMainPanel.this.m_BalanceText.setToolTipText(JAPMessages.getString(AccountSettingsPanel.MSG_SHOW_TRANSACTION_DETAILS));
                                    PaymentMainPanel.this.m_BalanceText.setName("Transaction");
                                } else {
                                    PaymentMainPanel.this.m_BalanceText.setVisible(false);
                                    PaymentMainPanel.this.m_btnCreateAccount.setVisible(true);
                                    PaymentMainPanel.this.m_BalanceText.setText("");
                                    PaymentMainPanel.this.m_BalanceText.setToolTipText(null);
                                }
                            } else {
                                GregorianCalendar calendarNextMonth = new GregorianCalendar();
                                calendarNextMonth.add(2, 1);
                                PaymentMainPanel.this.m_BalanceText.setText(JAPMessages.getString(AccountSettingsPanel.MSG_NO_CREDIT));
                            }
                        }
                    }
                    PaymentMainPanel.this.m_spentThisSession = AIControlChannel.getBytes();
                    PaymentMainPanel.this.m_labelSessionSpent.setText(Util.formatBytesValueWithUnit(PaymentMainPanel.this.m_spentThisSession, 2));
                    PaymentMainPanel.this.m_labelTotalSpent.setText(Util.formatBytesValueWithUnit(activeAccount.getCurrentSpent(), 2));
                    if (JAPController.getInstance().isConfigAssistantShown() && activeAccount.getCurrentCredit() + activeAccount.getCurrentSpent() <= 125000000L) {
                        PaymentMainPanel.this.m_notifiedEmpty = true;
                    }
                    if (!JAPModel.getInstance().isPaymentPopupsHidden()) {
                        if (a_bWarnIfNearlyEmpty && activeAccount.getCurrentCredit() <= 125000000L && !PaymentMainPanel.this.m_notifiedEmpty && activeAccount.isCharged(now) && PayAccountsFile.getInstance().getAlternativeChargedAccount(activeAccount.getPIID()) == null) {
                            PaymentMainPanel.this.m_notifiedEmpty = true;
                            new Thread(new Runnable(){

                                public void run() {
                                    if (balance.getVolumeBytesMonthly() > 0L && balance.canDoMonthlyOverusage(now)) {
                                        PaymentMainPanel.showMonthlyOverusageQuestion(activeAccount, JAPController.getInstance().getCurrentView(), true, PaymentMainPanel.this.m_view);
                                    } else if (JAPDialog.showYesNoDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(MSG_NEARLYEMPTY_CREATE_ACCOUNT))) {
                                        PaymentMainPanel.this.m_view.showPaymentDialog(JAPController.getInstance().getCurrentMixCascade().getPIID());
                                    }
                                }
                            }).start();
                        }
                        Timestamp warningTime = new Timestamp(System.currentTimeMillis() + 604800000L);
                        if (a_bWarnIfNearlyEmpty && !PaymentMainPanel.this.m_notifiedEmpty && activeAccount.isCharged(now) && !activeAccount.isCharged(warningTime) && PayAccountsFile.getInstance().getAlternativeChargedAccount(JAPController.getInstance().getCurrentMixCascade().getPIID()) == null && (balance.getVolumeBytesMonthly() == 0L || calendarEnd.get(2) == calendarNow.get(2))) {
                            PaymentMainPanel.this.m_notifiedEmpty = true;
                            new Thread(new Runnable(){

                                public void run() {
                                    if (JAPDialog.showYesNoDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(MSG_NEARLYEXPIRED_CREATE_ACCOUNT))) {
                                        PaymentMainPanel.this.m_view.showPaymentDialog(JAPController.getInstance().getCurrentMixCascade().getPIID());
                                    }
                                }
                            }).start();
                        }
                    }
                }
                PaymentMainPanel.this.m_BalanceTextSmall.setVisible(PaymentMainPanel.this.m_BalanceText.isVisible());
                PaymentMainPanel.this.m_BalanceTextSmall.setText(PaymentMainPanel.this.m_BalanceText.getText());
                PaymentMainPanel.this.m_BalanceTextSmall.setIcon(PaymentMainPanel.this.m_BalanceText.getIcon());
                PaymentMainPanel.this.m_BalanceTextSmall.setForeground(PaymentMainPanel.this.m_BalanceText.getForeground());
                PaymentMainPanel.this.m_BalanceTextSmall.setToolTipText(PaymentMainPanel.this.m_BalanceText.getToolTipText());
                PaymentMainPanel.this.m_BalanceTextSmall.setCursor(PaymentMainPanel.this.m_BalanceText.getCursor());
                PaymentMainPanel.this.m_BalanceTextSmall.setIcon(PaymentMainPanel.this.m_BalanceText.getIcon());
                PaymentMainPanel.this.m_BalanceTextSmall.setName(PaymentMainPanel.this.m_BalanceText.getName());
                PaymentMainPanel.this.m_BalanceSmallProgressBar.setValue(PaymentMainPanel.this.m_BalanceProgressBar.getValue());
                PaymentMainPanel.this.m_BalanceSmallProgressBar.setEnabled(PaymentMainPanel.this.m_BalanceProgressBar.isEnabled());
            }
        };
        this.m_queueUpdate.addJob(job);
    }

    public static void showMonthlyOverusageQuestion(PayAccount account, Component parent, boolean bOnConnectionToService, IPaymentDialogPresentator a_pdPresentator) {
        String message = "";
        if (account.getCurrentCredit() <= 0L) {
            message = message + JAPMessages.getString(MSG_MONTHLY_RATE_USED);
        } else if (bOnConnectionToService) {
            message = message + JAPMessages.getString(MSG_MONTHLY_RATE_ALMOST_USED);
        }
        PaymentMainPanel.showMonthlyOverusageQuestion(account, parent, message, JAPMessages.getString(MSG_BTN_ADDITIONAL_RATE), a_pdPresentator);
    }

    public static int showMonthlyOverusageQuestion(final PayAccount account, Component parent, String a_strWelcomeMessage, final String a_strNoButtonMessage, IPaymentDialogPresentator a_pdPresentator) {
        XMLBalance balance = account.getBalance();
        Timestamp tNow = new Timestamp(System.currentTimeMillis());
        if (balance == null) {
            return 1;
        }
        XMLBalance.MonthlyOverusage monthlyOverusage = balance.calculateMonthlyOverusage(tNow);
        if (a_strWelcomeMessage.trim().length() > 0) {
            a_strWelcomeMessage = "<p><b>" + a_strWelcomeMessage + "</b></p><br/>";
        }
        a_strWelcomeMessage = a_strWelcomeMessage + "<p>" + JAPMessages.getString(MSG_MONTHLY_RATE_OVERUSAGE_EXPLAIN, new Object[]{Util.formatTimestamp(monthlyOverusage.m_tEndOfCurrentPeriod, false), NumberFormat.getInstance(JAPMessages.getLocale()).format(monthlyOverusage.m_dFactor), Util.formatBytesValueWithUnit(monthlyOverusage.m_lAdditionalTraffic, 3), Util.formatBytesValueWithUnit((long)((double)account.getVolumeBytesMonthly() / monthlyOverusage.m_dFactor), 2)}) + "</p>";
        if (a_pdPresentator != null) {
            a_strWelcomeMessage = a_strWelcomeMessage + "<br/>" + JAPMessages.getString(MSG_ALTERNATIVE_ADDITIONAL_RATE);
        }
        JAPDialog dialog = new JAPDialog(parent, JAPMessages.getString(MSG_TITLE_USE_MONTHLY_VOLUME_PREMATURELY));
        final JCheckBox cbxAccept = new JCheckBox(JAPMessages.getString(MSG_CBX_ACCEPT_OVERUSAGE, new String[]{Util.formatBytesValueWithUnit(monthlyOverusage.m_lAdditionalTraffic, 3), NumberFormat.getInstance(JAPMessages.getLocale()).format((monthlyOverusage.m_dFactor - 1.0) * 100.0)}));
        SimpleWizardContentPane paneDecision = new SimpleWizardContentPane(dialog, a_strWelcomeMessage, new DialogContentPaneOptions(1)){

            public DialogContentPane.CheckError checkYesOK() {
                DialogContentPane.CheckError errors = null;
                if (!cbxAccept.isSelected()) {
                    errors = new DialogContentPane.CheckError(JAPMessages.getString(MSG_HINT_ACCEPT_OVERUSAGE));
                }
                return errors;
            }

            public boolean hideButtonNo() {
                return false;
            }

            public String getButtonNoText() {
                return a_strNoButtonMessage;
            }

            public String getButtonYesOKText() {
                return JAPMessages.getString(DialogContentPane.MSG_OK);
            }
        };
        paneDecision.setDefaultButtonOperation(49160);
        paneDecision.getContentPane().add(cbxAccept);
        final IReturnRunnable runRequestOverusage = new IReturnRunnable(){
            private Object info = null;

            public void run() {
                try {
                    this.info = account.requestMonthlyOverusage();
                }
                catch (Exception a_e) {
                    LogHolder.log(2, LogType.PAY, a_e);
                    this.info = a_e;
                }
            }

            public Object getValue() {
                return this.info;
            }
        };
        WorkerContentPane paneWorker = new WorkerContentPane(dialog, JAPMessages.getString(MSG_WAIT_REQUESTING_DATA_VOLUME), (DialogContentPane)paneDecision, (Runnable)runRequestOverusage){

            public boolean isMoveBackAllowed() {
                return runRequestOverusage.getValue() == null || !(runRequestOverusage.getValue() instanceof XMLAccountInfo);
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }
        };
        final SimpleWizardContentPane paneSuccess = new SimpleWizardContentPane(dialog, "<p>" + JAPMessages.getString(MSG_SUCCESS_OVERUSAGE, new String[]{Util.formatBytesValueWithUnit(monthlyOverusage.m_lAdditionalTraffic, 2), Util.formatTimestamp(monthlyOverusage.m_tEndOfCurrentPeriod, false), NumberFormat.getInstance(JAPMessages.getLocale()).format(monthlyOverusage.m_dFactor)}) + "</p><br>" + JAPMessages.getString(MSG_HINT_AUTO_BALANCE_UPDATES), new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_INFO)), new DialogContentPaneOptions(-1, (DialogContentPane)paneWorker)){

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }

            public boolean isSkippedAsNextContentPane() {
                return runRequestOverusage.getValue() == null || !(runRequestOverusage.getValue() instanceof XMLAccountInfo);
            }
        };
        SimpleWizardContentPane paneFailed = new SimpleWizardContentPane(dialog, "Text", new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR)), new DialogContentPaneOptions(paneSuccess)){

            public boolean hideButtonYesOK() {
                return true;
            }

            public boolean hideButtonCancel() {
                return false;
            }

            public boolean isSkippedAsNextContentPane() {
                return !paneSuccess.isSkippedAsNextContentPane();
            }

            public DialogContentPane.CheckError checkUpdate() {
                String strErrorMessage = JAPMessages.getString(MSG_FAILED_OVERUSAGE) + " ";
                strErrorMessage = runRequestOverusage.getValue() == null || !(runRequestOverusage.getValue() instanceof XMLErrorMessage) ? strErrorMessage + JAPMessages.getString(MSG_FAILED_OVERUSAGE_NO_CONNECTION) : (((XMLErrorMessage)runRequestOverusage.getValue()).getXmlErrorCode() == 20 ? strErrorMessage + JAPMessages.getString(MSG_FAILED_OVERUSAGE_DOUBLE) : (((XMLErrorMessage)runRequestOverusage.getValue()).getXmlErrorCode() == 22 ? strErrorMessage + JAPMessages.getString(MSG_FAILED_OVERUSAGE_NOT_SYNCHRONIZED) : strErrorMessage + JAPMessages.getString(MSG_FAILED_OVERUSAGE_NO_CONNECTION)));
                this.setText("<font color=\"red\">" + strErrorMessage + "</font>");
                return null;
            }
        };
        paneDecision.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (paneDecision.getButtonValue() == 1) {
            if (a_pdPresentator != null) {
                a_pdPresentator.showPaymentDialog(account.getPIID());
            }
            return 0;
        }
        if (runRequestOverusage.getValue() != null && runRequestOverusage.getValue() instanceof XMLAccountInfo) {
            return 0;
        }
        return 2;
    }

    private void allowShowingError() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = PaymentMainPanel.this.SYNC_SHOW_ERROR;
                synchronized (object) {
                    PaymentMainPanel.this.m_bShowingError = false;
                }
            }
        }.start();
    }

    private void loadIcons() {
        this.m_accountIcons = new ImageIcon[JAPConstants.ACCOUNTICONFNARRAY.length];
        for (int i = 0; i < JAPConstants.ACCOUNTICONFNARRAY.length; ++i) {
            this.m_accountIcons[i] = GUIUtils.loadImageIcon(JAPConstants.ACCOUNTICONFNARRAY[i], false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < MSG_PAYMENT_ERRORS.length; ++i) {
            PaymentMainPanel.MSG_PAYMENT_ERRORS[i] = (class$jap$pay$PaymentMainPanel == null ? PaymentMainPanel.class$("jap.pay.PaymentMainPanel") : class$jap$pay$PaymentMainPanel).getName() + MSG_PAYMENT_ERRORS[i];
        }
    }

    private class MyPaymentListener
    implements IPaymentListener {
        private MyPaymentListener() {
        }

        public void accountActivated(PayAccount acc) {
            PaymentMainPanel.this.updateDisplay(acc, true);
        }

        public void accountAdded(PayAccount acc) {
        }

        public void accountRemoved(PayAccount acc) {
        }

        public void creditChanged(PayAccount acc) {
            PaymentMainPanel.this.updateDisplay(acc, true);
        }

        private String formatCascadeName(MixCascade a_cascade) {
            String strCascadeName = a_cascade == null || a_cascade.getName() == null ? "" : ", <b>" + a_cascade.getName() + "</b>,";
            return strCascadeName;
        }

        private String formatOrganisation(String a_strOrganisation) {
            a_strOrganisation = "JonDos GmbH";
            String strOrganisation = a_strOrganisation == null ? "" : "<b>" + a_strOrganisation + "</b>";
            return strOrganisation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accountCertRequested(final MixCascade a_connectedCascade) throws AccountEmptyException {
            if (PayAccountsFile.getInstance().isAIAccountErrorIgnored()) {
                return;
            }
            if (JAPModel.getInstance().isPaymentPopupsHidden()) {
                return;
            }
            PayAccountsFile payAccounts = PayAccountsFile.getInstance();
            AccountEmptyException exception = null;
            final PaymentInstanceDBEntry piEntry = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PaymentMainPanel.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(a_connectedCascade.getPIID());
            final boolean bFreeCodeAllowed = piEntry != null && piEntry.getFreeCodeURL() != null && PayAccountsFile.getInstance().isNewUser();
            String strOrganisation = null;
            final JAPDialog.AbstractLinkedURLAdapter helpAdapter = new JAPDialog.AbstractLinkedURLAdapter("premium"){

                public URL getUrl() {
                    if (bFreeCodeAllowed) {
                        return piEntry.getFreeCodeURL();
                    }
                    return null;
                }

                public String getMessage() {
                    if (bFreeCodeAllowed) {
                        return JAPMessages.getString(PayAccountsFile.MSG_GET_FREE_CODE);
                    }
                    return super.getMessage();
                }

                public void clicked(boolean a_bState) {
                    JAPController.getInstance().allowDirectProxyDomain(this.getUrl());
                    super.clicked(a_bState);
                }

                public boolean isOnTop() {
                    return true;
                }
            };
            Runnable run = null;
            String strMessage = "";
            if (piEntry != null) {
                strOrganisation = piEntry.getOrganisation();
            }
            String fstrOrganisation = strOrganisation;
            final MixCascade cascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = PaymentMainPanel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(a_connectedCascade.getId());
            Object object = PaymentMainPanel.this.SYNC_SHOW_ERROR;
            synchronized (object) {
                if (PaymentMainPanel.this.m_bShowingError) {
                    return;
                }
                PaymentMainPanel.this.m_bShowingError = true;
            }
            final PayAccount account = payAccounts.getActiveAccount();
            if (payAccounts.getNumAccounts() == 0 || account != null && !account.getPIID().equals(a_connectedCascade.getPIID())) {
                exception = new AccountEmptyException(a_connectedCascade);
                PaymentInstanceDBEntry pi = a_connectedCascade.getPaymentInstance();
                if (pi != null && pi.isTest() || !JAPModel.getInstance().isCascadeAutoSwitched()) {
                    JAPController.getInstance().stop();
                } else if (TrustModel.getCurrentTrustModel().isPaymentForced() || !TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                    if (JAPModel.getInstance().isConfigAssistantAutomaticallyShown()) {
                        exception = null;
                        JAPController.getInstance().showInstallationAssistant(4);
                    } else {
                        JAPController.getInstance().stop();
                    }
                }
                run = new Runnable(){

                    public void run() {
                        int answer;
                        JAPDialog.Options options = new JAPDialog.Options(2){

                            public String getCancelText() {
                                return JAPMessages.getString(MSG_MAYBE_LATER);
                            }
                        };
                        PaymentInstanceDBEntry pi = a_connectedCascade.getPaymentInstance();
                        String strMessageCreate = MSG_CREATE_ACCOUNT_QUESTION;
                        if (pi != null && pi.isTest()) {
                            strMessageCreate = MSG_TEST_PREMIUM_BETA;
                        }
                        if ((answer = JAPDialog.showConfirmDialog(JAPController.getInstance().getCurrentView(), "" + JAPMessages.getString(MSG_WITH_COSTS, MyPaymentListener.this.formatCascadeName(cascade)) + " " + JAPMessages.getString(strMessageCreate), JAPMessages.getString(MSG_CREATE_ACCOUNT_TITLE), options, 3, (JAPDialog.ILinkedInformation)helpAdapter)) == 0) {
                            PaymentMainPanel.this.m_view.showPaymentDialog(a_connectedCascade.getPIID());
                        } else if (JAPModel.getInstance().isCascadeAutoSwitched()) {
                            JAPController.getInstance().setAllowPaidServices(false);
                            if (!TrustModel.getCurrentTrustModel().isTrusted(JAPController.getInstance().getCurrentMixCascade())) {
                                JAPController.getInstance().switchToNextMixCascade();
                            }
                            if (TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                                JAPController.getInstance().start();
                            }
                        }
                        PaymentMainPanel.this.allowShowingError();
                    }
                };
            } else {
                final Timestamp tNow = new Timestamp(System.currentTimeMillis());
                if (account == null) {
                    exception = new AccountEmptyException(a_connectedCascade);
                    PaymentInstanceDBEntry pi = a_connectedCascade.getPaymentInstance();
                    if (pi != null && pi.isTest() || !JAPModel.getInstance().isCascadeAutoSwitched()) {
                        JAPController.getInstance().stop();
                    } else if (TrustModel.getCurrentTrustModel().isPaymentForced() || !TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                        if (JAPModel.getInstance().isConfigAssistantAutomaticallyShown()) {
                            exception = null;
                            JAPController.getInstance().showInstallationAssistant(4);
                        } else {
                            JAPController.getInstance().stop();
                        }
                    }
                    run = new Runnable(){

                        public void run() {
                            JAPDialog.showErrorDialog(JAPController.getInstance().getCurrentView(), "" + JAPMessages.getString(MSG_NO_ACTIVE_ACCOUNT), (JAPDialog.ILinkedInformation)helpAdapter);
                            PaymentMainPanel.this.m_view.showConfigDialog("PAYMENT_TAB", null);
                            PaymentMainPanel.this.allowShowingError();
                        }
                    };
                } else if (!account.isCharged(tNow)) {
                    exception = new AccountEmptyException(a_connectedCascade, account);
                    PaymentInstanceDBEntry pi = a_connectedCascade.getPaymentInstance();
                    if (pi != null && pi.isTest() || !JAPModel.getInstance().isCascadeAutoSwitched()) {
                        JAPController.getInstance().stop();
                    } else if (TrustModel.getCurrentTrustModel().isPaymentForced() || !TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                        if (JAPModel.getInstance().isConfigAssistantAutomaticallyShown()) {
                            exception = null;
                            JAPController.getInstance().showInstallationAssistant(4);
                        } else {
                            JAPController.getInstance().stop();
                        }
                    }
                    run = new Runnable(){

                        public void run() {
                            if (PayAccount.canDoMonthlyOverusage(account, tNow)) {
                                PaymentMainPanel.showMonthlyOverusageQuestion(account, JAPController.getInstance().getCurrentView(), true, PaymentMainPanel.this.m_view);
                            } else {
                                String message = "" + JAPMessages.getString(MSG_WITH_COSTS, MyPaymentListener.this.formatCascadeName(cascade)) + " ";
                                boolean bOpenTransaction = false;
                                String strTitle = null;
                                if (account.isWaitingForTransaction()) {
                                    message = message + JAPMessages.getString(MSG_OPEN_TRANSACTION);
                                    bOpenTransaction = true;
                                } else {
                                    PaymentInstanceDBEntry pi;
                                    String strMessageCreate = MSG_CREATE_ACCOUNT_QUESTION;
                                    if (cascade != null && (pi = cascade.getPaymentInstance()) != null && pi.isTest()) {
                                        strMessageCreate = MSG_TEST_PREMIUM_BETA;
                                    }
                                    message = message + JAPMessages.getString(strMessageCreate);
                                    strTitle = JAPMessages.getString(MSG_CREATE_ACCOUNT_TITLE);
                                }
                                JAPDialog.Options options = new JAPDialog.Options(2){

                                    public String getCancelText() {
                                        return JAPMessages.getString(MSG_MAYBE_LATER);
                                    }
                                };
                                int answer = JAPDialog.showConfirmDialog(JAPController.getInstance().getCurrentView(), message, strTitle, options, 3, (JAPDialog.ILinkedInformation)helpAdapter);
                                if (answer == 0) {
                                    if (bOpenTransaction) {
                                        PaymentMainPanel.this.m_view.showConfigDialog("PAYMENT_TAB", account);
                                    } else {
                                        PaymentMainPanel.this.m_view.showPaymentDialog(a_connectedCascade.getPIID());
                                    }
                                } else if (JAPModel.getInstance().isCascadeAutoSwitched()) {
                                    JAPController.getInstance().setAllowPaidServices(false);
                                    if (!TrustModel.getCurrentTrustModel().isTrusted(JAPController.getInstance().getCurrentMixCascade())) {
                                        JAPController.getInstance().switchToNextMixCascade();
                                    }
                                    if (TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                                        JAPController.getInstance().start();
                                    }
                                }
                            }
                            PaymentMainPanel.this.allowShowingError();
                        }
                    };
                }
            }
            if (run != null && exception != null) {
                if (JAPDialog.isConsoleOnly()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            } else {
                PaymentMainPanel.this.allowShowingError();
            }
            if (exception != null) {
                throw exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accountError(XMLErrorMessage a_msg, boolean a_bIgnore) {
            boolean bFreeCodeAllowed;
            String strOrganisation = null;
            if (a_msg.getXmlErrorCode() <= 0 || a_msg.getXmlErrorCode() < 0) {
                return;
            }
            LogHolder.log(3, LogType.PAY, a_msg);
            if (JAPModel.isAutomaticallyReconnected() || PayAccountsFile.getInstance().isAIAccountErrorIgnored()) {
                return;
            }
            if (JAPModel.getInstance().isPaymentPopupsHidden()) {
                return;
            }
            final MixCascade cascade = JAPController.getInstance().getCurrentMixCascade();
            final PaymentInstanceDBEntry piEntry = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PaymentMainPanel.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(cascade.getPIID());
            boolean bl = bFreeCodeAllowed = piEntry != null && piEntry.getFreeCodeURL() != null && PayAccountsFile.getInstance().isNewUser();
            if (piEntry != null) {
                strOrganisation = piEntry.getOrganisation();
            }
            String fstrOrganisation = strOrganisation;
            Object object = PaymentMainPanel.this.SYNC_SHOW_ERROR;
            synchronized (object) {
                if (PaymentMainPanel.this.m_bShowingError || a_bIgnore || !cascade.equals(a_msg.getService())) {
                    return;
                }
                PaymentMainPanel.this.m_bShowingError = true;
            }
            final XMLErrorMessage msg = a_msg;
            new Thread(new Runnable(){

                public void run() {
                    String message = PaymentMainPanel.translateBIError(msg);
                    JAPDialog.AbstractLinkedURLAdapter adapter = new JAPDialog.AbstractLinkedURLAdapter("premium"){

                        public URL getUrl() {
                            if (msg.getXmlErrorCode() == 21) {
                                try {
                                    return new URL("mailto:payment@jondos.de");
                                }
                                catch (MalformedURLException e) {
                                    LogHolder.log(3, LogType.GUI, e);
                                }
                            } else if (bFreeCodeAllowed) {
                                return piEntry.getFreeCodeURL();
                            }
                            return null;
                        }

                        public String getMessage() {
                            if (msg.getXmlErrorCode() != 21 && bFreeCodeAllowed) {
                                return JAPMessages.getString(PayAccountsFile.MSG_GET_FREE_CODE);
                            }
                            return super.getMessage();
                        }

                        public void clicked(boolean a_bState) {
                            JAPController.getInstance().allowDirectProxyDomain(this.getUrl());
                            super.clicked(a_bState);
                        }

                        public boolean isOnTop() {
                            return true;
                        }
                    };
                    if (msg.getXmlErrorCode() == 10) {
                        PaymentInstanceDBEntry pi;
                        String strMessageCreate = MSG_CREATE_ACCOUNT_QUESTION;
                        if (cascade != null && (pi = cascade.getPaymentInstance()) != null && pi.isTest()) {
                            strMessageCreate = MSG_TEST_PREMIUM_BETA;
                        }
                        message = message + "<br><br>" + JAPMessages.getString(MSG_WITH_COSTS, MyPaymentListener.this.formatCascadeName(cascade)) + " " + JAPMessages.getString(strMessageCreate);
                        PayAccount account = PayAccountsFile.getInstance().getActiveAccount();
                        if (PayAccount.canDoMonthlyOverusage(account, new Timestamp(System.currentTimeMillis()))) {
                            PaymentMainPanel.showMonthlyOverusageQuestion(account, JAPController.getInstance().getCurrentView(), true, PaymentMainPanel.this.m_view);
                        } else {
                            JAPDialog.Options options = new JAPDialog.Options(2){

                                public String getCancelText() {
                                    return JAPMessages.getString(MSG_MAYBE_LATER);
                                }
                            };
                            int answer = JAPDialog.showConfirmDialog(JAPController.getInstance().getCurrentView(), message, JAPMessages.getString(MSG_CREATE_ACCOUNT_TITLE), options, 3, (JAPDialog.ILinkedInformation)adapter);
                            if (answer == 0) {
                                new Thread(new Runnable(){

                                    public void run() {
                                        if (cascade.isPayment()) {
                                            PaymentMainPanel.this.m_view.showPaymentDialog(cascade.getPIID());
                                        } else {
                                            PaymentMainPanel.this.m_view.showConfigDialog("PAYMENT_TAB", new Boolean(true));
                                        }
                                    }
                                }).start();
                            } else if (JAPModel.getInstance().isCascadeAutoSwitched()) {
                                JAPController.getInstance().setAllowPaidServices(false);
                                if (!TrustModel.getCurrentTrustModel().isTrusted(JAPController.getInstance().getCurrentMixCascade())) {
                                    JAPController.getInstance().switchToNextMixCascade();
                                }
                                if (TrustModel.getCurrentTrustModel().hasFreeCascades()) {
                                    JAPController.getInstance().start();
                                }
                            }
                        }
                    } else if (!JAPModel.getInstance().isCascadeAutoSwitched() || !JAPModel.isAutomaticallyReconnected()) {
                        message = message + "<br><br>" + JAPMessages.getString(MSG_ENABLE_AUTO_SWITCH);
                        if (0 == JAPDialog.showConfirmDialog(JAPController.getInstance().getCurrentView(), message, JAPMessages.getString(JAPDialog.MSG_TITLE_WARNING), 0, 2, (JAPDialog.ILinkedInformation)adapter)) {
                            JAPModel.getInstance().setCascadeAutoSwitch(true);
                            JAPModel.getInstance().setAutoReConnect(true);
                            JAPController.getInstance().switchToNextMixCascade();
                            JAPController.getInstance().start();
                        }
                    } else {
                        JAPDialog.showErrorDialog(JAPController.getInstance().getCurrentView(), message, (JAPDialog.ILinkedInformation)adapter);
                    }
                    PaymentMainPanel.this.allowShowingError();
                }
            }).start();
        }

        public void gotCaptcha(ICaptchaSender a_source, IImageEncodedCaptcha a_captcha) {
        }
    }
}

