/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.MD5InputStream;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import HTTPClient.VerifyMD5;
import java.io.IOException;

class ContentMD5Module
implements HTTPClientModule,
GlobalConstants {
    ContentMD5Module() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        String md5_digest = resp.getHeader("Content-MD5");
        String trailer = resp.getHeader("Trailer");
        boolean md5_tok = false;
        try {
            if (trailer != null) {
                md5_tok = Util.hasToken(trailer, "Content-MD5");
            }
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (md5_digest == null && !md5_tok || resp.getHeader("Transfer-Encoding") != null) {
            return;
        }
        if (GlobalConstants.DebugMods) {
            if (md5_digest != null) {
                Util.logLine("CMD5M: Received digest: " + md5_digest + " - pushing md5-check-stream");
            } else {
                Util.logLine("CMD5M: Expecting digest in trailer  - pushing md5-check-stream");
            }
        }
        resp.inp_stream = new MD5InputStream(resp.inp_stream, new VerifyMD5(resp));
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

