/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPathInfo;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.crypto.MyRandom;
import anon.crypto.SignatureVerifier;
import anon.crypto.X509AuthorityKeyIdentifier;
import anon.crypto.X509BasicConstraints;
import anon.crypto.X509KeyUsage;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CertPath
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "CertPath";
    public static final String XML_ATTR_CLASS = "rootCertificateClass";
    public static final String XML_ATTR_TYPE = "certificateType";
    public static final int NO_ERRORS = 0;
    public static final int ERROR_VERIFICATION = 1;
    public static final int ERROR_VALIDITY = 2;
    public static final int ERROR_REVOCATION = 3;
    public static final int ERROR_UNKNOWN_CRITICAL_EXTENSION = 4;
    public static final int ERROR_BASIC_CONSTRAINTS_IS_CA = 5;
    public static final int ERROR_BASIC_CONSTRAINTS_IS_NO_CA = 6;
    public static final int ERROR_BASIC_CONSTRAINTS_PATH_TOO_LONG = 7;
    public static final int ERROR_KEY_USAGE = 8;
    public static final int ERROR_VALIDITY_SEVERE = 9;
    private static final int VERIFICATION_INTERVAL = 3600000;
    private static final int VERIFICATION_INTERVAL_MAX = 86400000;
    private static final MyRandom RANDOM_VERIFICATION = new MyRandom();
    private static final long GRACE_PERIOD = 5184000000L;
    private int m_documentType;
    private Vector m_certificates;
    private boolean m_rootFound;
    private boolean m_valid;
    private boolean m_verified;
    private long m_verificationTime;
    private int m_pathError;
    private int m_errorPosition;

    private CertPath(JAPCertificate a_firstCert, int a_documentType) {
        this.m_certificates = new Vector();
        this.m_documentType = a_documentType;
        this.m_verificationTime = 0L;
        this.m_verified = false;
        this.m_pathError = 0;
        this.m_errorPosition = -1;
        this.appendCertificate(a_firstCert);
        this.m_rootFound = false;
    }

    protected CertPath(Element a_elemCertPath) throws XMLParseException {
        this.m_pathError = 0;
        if (a_elemCertPath == null || !a_elemCertPath.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException("##__root__##", XML_ELEMENT_NAME);
        }
        XMLUtil.parseAttribute((Node)a_elemCertPath, XML_ATTR_TYPE, -1);
        NodeList listCerts = a_elemCertPath.getElementsByTagName("X509Certificate");
        if (listCerts.getLength() == 0) {
            throw new XMLParseException("No certificates found!");
        }
        this.m_certificates = new Vector(listCerts.getLength());
        for (int i = 0; i < listCerts.getLength(); ++i) {
            this.m_certificates.addElement(JAPCertificate.getInstance(listCerts.item(i)));
        }
        this.m_valid = this.m_documentType == 0 ? true : this.buildAndValidate(null);
    }

    public static CertPath getRootInstance(JAPCertificate a_rootCert) {
        CertPath rootCertPath = new CertPath(a_rootCert, 0);
        rootCertPath.m_valid = true;
        return rootCertPath;
    }

    public static CertPath getInstance(JAPCertificate a_firstCert, int a_documentType, Vector a_pathCertificates) {
        if (a_firstCert == null) {
            return null;
        }
        CertificateInfoStructure cachedPath = null;
        cachedPath = SignatureVerifier.getInstance().getVerificationCertificateStore().getCertificateInfoStructure(a_firstCert, CertPath.getCertType(a_documentType));
        if (cachedPath != null && cachedPath.getCertPath().m_valid && (cachedPath.getCertPath().checkValidity(new Date()) || !CertPath.isPossiblyValid(a_firstCert, a_pathCertificates))) {
            return cachedPath.getCertPath();
        }
        CertPath certPath = new CertPath(a_firstCert, a_documentType);
        Vector pathCerts = (Vector)a_pathCertificates.clone();
        certPath.m_valid = certPath.buildAndValidate(pathCerts);
        if (!certPath.m_valid && cachedPath != null) {
            return cachedPath.getCertPath();
        }
        SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithVerification(certPath, CertPath.getCertType(a_documentType), false);
        return certPath;
    }

    private static boolean isPossiblyValid(JAPCertificate a_firstCert, Vector a_pathCertificates) {
        if (a_firstCert.getValidity().isValid(new Date())) {
            Enumeration certs = a_pathCertificates.elements();
            while (certs.hasMoreElements()) {
                JAPCertificate nextCert = (JAPCertificate)certs.nextElement();
                if (!nextCert.getValidity().isValid(new Date())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildAndValidate(Vector a_pathCertificates) {
        JAPCertificate current = null;
        int pathPosition = 0;
        int iPathError = 0;
        this.m_errorPosition = -1;
        this.build(a_pathCertificates);
        Vector vector = this.m_certificates;
        synchronized (vector) {
            Enumeration certificates = this.m_certificates.elements();
            if (certificates.hasMoreElements()) {
                current = (JAPCertificate)certificates.nextElement();
                do {
                    JAPCertificate issuer = null;
                    if (certificates.hasMoreElements()) {
                        issuer = (JAPCertificate)certificates.nextElement();
                    }
                    if ((iPathError = this.validate(current, pathPosition, issuer)) != 0 && (iPathError == 1 || iPathError == 3 || iPathError == 4 || iPathError == 9)) {
                        this.m_errorPosition = pathPosition;
                        this.m_pathError = iPathError;
                    }
                    current = issuer;
                    ++pathPosition;
                } while (current != null);
            }
            return true;
        }
    }

    private void build(Vector a_pathCertificates) {
        JAPCertificate pathCertificate = null;
        if (a_pathCertificates != null) {
            pathCertificate = CertPath.doNameAndKeyChaining(this.getLastCertificate(), a_pathCertificates, false);
        }
        while (pathCertificate != null) {
            this.appendCertificate(pathCertificate);
            pathCertificate = CertPath.doNameAndKeyChaining(pathCertificate, a_pathCertificates, false);
        }
        this.findVerifier();
    }

    private void findVerifier() {
        Vector rootCertificates = SignatureVerifier.getInstance().getVerificationCertificateStore().getAvailableCertificatesByType(CertPath.getRootCertType(this.m_documentType));
        JAPCertificate trustAnchor = CertPath.doNameAndKeyChaining(this.getLastCertificate(), rootCertificates, false);
        if (trustAnchor == null) {
            rootCertificates = SignatureVerifier.getInstance().getVerificationCertificateStore().getUnavailableCertificatesByType(CertPath.getRootCertType(this.m_documentType));
            trustAnchor = CertPath.doNameAndKeyChaining(this.getLastCertificate(), rootCertificates, false);
        }
        if (trustAnchor != null) {
            this.m_rootFound = true;
            this.appendCertificate(trustAnchor);
        }
    }

    private static JAPCertificate doNameAndKeyChaining(JAPCertificate a_cert, Vector a_possibleIssuers, boolean a_bAllowSelfSigned) {
        JAPCertificate sameIssuer = null;
        Enumeration issuers = a_possibleIssuers.elements();
        while (issuers.hasMoreElements()) {
            X509AuthorityKeyIdentifier aki;
            Object obj = issuers.nextElement();
            JAPCertificate issuer = obj instanceof JAPCertificate ? (JAPCertificate)obj : ((CertificateInfoStructure)obj).getCertificate();
            if (a_cert.getIssuer() == null || issuer.getSubject() == null || !a_bAllowSelfSigned && a_cert.equals(issuer) || !a_cert.getIssuer().equals(issuer.getSubject()) || (aki = (X509AuthorityKeyIdentifier)a_cert.getExtensions().getExtension(X509AuthorityKeyIdentifier.IDENTIFIER)) != null && !aki.getValue().equals(issuer.getSubjectKeyIdentifier())) continue;
            if (a_cert.equals(issuer)) {
                sameIssuer = issuer;
                continue;
            }
            return issuer;
        }
        return sameIssuer;
    }

    private int validate(JAPCertificate a_cert, int a_position, JAPCertificate a_issuer) {
        X509KeyUsage keyUsage;
        if (a_issuer != null && !a_cert.verify(a_issuer)) {
            return 1;
        }
        if (a_cert.isRevoked()) {
            return 3;
        }
        if (a_cert.getExtensions().hasUnknownCriticalExtensions()) {
            return 4;
        }
        Date now = new Date();
        if (!a_cert.getValidity().isValid(now)) {
            if (a_cert.getValidity().getValidTo().getTime() + 5184000000L < now.getTime()) {
                return 9;
            }
            return 2;
        }
        X509BasicConstraints basicConstraints = (X509BasicConstraints)a_cert.getExtensions().getExtension(X509BasicConstraints.IDENTIFIER);
        if (basicConstraints != null) {
            if (basicConstraints.isCA()) {
                if (a_position == 0) {
                    return 5;
                }
                int maxPathLength = basicConstraints.getPathLengthConstraint();
                if (maxPathLength != -1 && maxPathLength < a_position) {
                    return 7;
                }
            } else if (a_position > 0) {
                return 6;
            }
        }
        if ((keyUsage = (X509KeyUsage)a_cert.getExtensions().getExtension(X509KeyUsage.IDENTIFIER)) != null && (a_position == 0 ? !keyUsage.allowsDigitalSignature() : !keyUsage.allowsDigitalSignature() || !keyUsage.allowsKeyCertSign())) {
            return 8;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        if (a_doc == null) {
            return null;
        }
        Element elemCertPath = a_doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(elemCertPath, XML_ATTR_TYPE, this.m_documentType);
        Vector vector = this.m_certificates;
        synchronized (vector) {
            Enumeration enumCerts = this.m_certificates.elements();
            while (enumCerts.hasMoreElements()) {
                elemCertPath.appendChild(((JAPCertificate)enumCerts.nextElement()).toXmlElement(a_doc));
            }
        }
        return elemCertPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendCertificate(JAPCertificate a_certificate) {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            if (!this.m_certificates.contains(a_certificate)) {
                this.m_certificates.addElement(a_certificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLastCertificate() {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            if (this.m_certificates.size() > 1) {
                this.m_certificates.removeElementAt(this.m_certificates.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAPCertificate getLastCertificate() {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            if (this.m_certificates.size() > 0) {
                return (JAPCertificate)this.m_certificates.lastElement();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAPCertificate getFirstCertificate() {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            if (this.m_certificates.size() > 0) {
                return (JAPCertificate)this.m_certificates.firstElement();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAPCertificate getSecondCertificate() {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            if (this.m_certificates.size() <= 1) {
                return null;
            }
            return (JAPCertificate)this.m_certificates.elementAt(1);
        }
    }

    private static int getRootCertType(int a_documentClass) {
        switch (a_documentClass) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 10;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    private static int getCertType(int a_documentClass) {
        switch (a_documentClass) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 9;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValidity(Date a_date) {
        if (a_date == null) {
            return false;
        }
        Vector vector = this.m_certificates;
        synchronized (vector) {
            Enumeration enumCerts = this.m_certificates.elements();
            while (enumCerts.hasMoreElements()) {
                if (((JAPCertificate)enumCerts.nextElement()).getValidity().isValid(a_date)) continue;
                return false;
            }
            return true;
        }
    }

    protected boolean isVerifier(JAPCertificate a_certificate) {
        if (a_certificate == null) {
            return false;
        }
        if (!this.m_valid) {
            return false;
        }
        if (this.m_rootFound && a_certificate.equals(this.getLastCertificate())) {
            return true;
        }
        return this.getLastCertificate().verify(a_certificate);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean verify() {
        block10: {
            if (this.m_documentType == 0) {
                return true;
            }
            long verificationDelta = System.currentTimeMillis() - this.m_verificationTime;
            if (verificationDelta < 3600000L) {
                return this.m_verified;
            }
            if (verificationDelta < 86400000L && 90 > RANDOM_VERIFICATION.nextInt(100)) {
                return this.m_verified;
            }
            this.m_valid = this.buildAndValidate(null);
            this.m_verificationTime = System.currentTimeMillis();
            CertificateInfoStructure rootCert = SignatureVerifier.getInstance().getVerificationCertificateStore().getCertificateInfoStructure(this.getLastCertificate());
            if (this.m_rootFound) {
                if (rootCert != null && rootCert.getCertificateType() == CertPath.getRootCertType(this.m_documentType)) {
                    if (rootCert.isAvailable() && this.m_valid) {
                        this.m_verified = true;
                        return true;
                    }
                    break block10;
                } else {
                    if (rootCert != null && rootCert.getCertificateType() != CertPath.getRootCertType(this.m_documentType)) {
                        LogHolder.log(1, LogType.CRYPTO, "Verification root certificate found in wrong type path! Cert doctype: " + rootCert.getCertificateType() + " Expected doc type: " + CertPath.getRootCertType(this.m_documentType) + (rootCert.getCertificate() != null ? " SKI:" + rootCert.getCertificate().getSubjectKeyIdentifier() : ""));
                        this.m_verified = false;
                        return false;
                    }
                    this.removeLastCertificate();
                    this.m_rootFound = false;
                    this.resetVerification();
                    return this.verify();
                }
            }
            Vector trustedCerts = new Vector();
            trustedCerts.addElement(this.getLastCertificate());
            if (CertPath.doNameAndKeyChaining(this.getLastCertificate(), trustedCerts, true) != null) {
                trustedCerts = SignatureVerifier.getInstance().getVerificationCertificateStore().getAvailableCertificatesByType(CertPath.getCertType(this.m_documentType));
                if (this.m_valid && CertPath.doNameAndKeyChaining(this.getLastCertificate(), trustedCerts, true) != null) {
                    this.m_verified = true;
                    return true;
                }
            }
        }
        this.m_verified = false;
        return false;
    }

    public int length() {
        return this.m_certificates.size();
    }

    protected void resetVerification() {
        this.m_verificationTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Vector vector = this.m_certificates;
        synchronized (vector) {
            String certPath = new String("Certification Path (" + this.length() + "):");
            String tabs = new String();
            for (int i = this.m_certificates.size(); i > 0; --i) {
                tabs = tabs + "\t";
                certPath = certPath + "\n" + tabs + ((JAPCertificate)this.m_certificates.elementAt(i - 1)).getSubject().getCommonName();
            }
            return certPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertPathInfo getPathInfo() {
        JAPCertificate first = null;
        JAPCertificate second = null;
        JAPCertificate root = null;
        Vector subCAs = null;
        Vector vector = this.m_certificates;
        synchronized (vector) {
            boolean verified = this.verify();
            int len = this.length();
            first = this.getFirstCertificate();
            if (len > 1 && this.m_rootFound) {
                root = this.getLastCertificate();
                --len;
            }
            if (len > 1) {
                second = this.getSecondCertificate();
            }
            if (len > 2) {
                subCAs = new Vector();
                for (int i = 2; i < len; ++i) {
                    subCAs.addElement(this.m_certificates.elementAt(i));
                }
            }
        }
        CertPathInfo info = new CertPathInfo(first, second, root, subCAs, 1);
        info.setVerified(this.m_errorPosition);
        return info;
    }

    public boolean isValidPath() {
        return this.m_valid;
    }

    protected Vector getCertificates() {
        Vector certs = (Vector)this.m_certificates.clone();
        if (this.m_rootFound) {
            certs.removeElementAt(certs.size() - 1);
        }
        return certs;
    }

    public int getErrorCode() {
        return this.m_pathError;
    }

    public int getErrorPosition() {
        return this.m_errorPosition;
    }
}

