/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.panels.CertPanel;
import mixconfig.panels.OtherMixPanel;

public class PreviousMixPanel
extends OtherMixPanel
implements ChangeListener {
    public PreviousMixPanel() {
        super("Previous Mix");
        GridBagConstraints c = super.getGridBagConstraints();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 2;
        c.weighty = 1.0;
        this.add((Component)new JLabel(), c);
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.removeChangeListener(this);
        a_conf.addChangeListener(this);
        this.setEnabled(this.getConfiguration().getMixType() != 1 && (!this.getConfiguration().isAutoConfigurationAllowed() || this.getConfiguration().isFallbackEnabled()));
        this.enableComponents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e instanceof ConfigurationEvent) {
                ConfigurationEvent c = (ConfigurationEvent)e;
                if (c.getModifiedXMLPath().equals("General/MixType") || c.getModifiedXMLPath().indexOf("Network/InfoService/AllowAutoConfiguration") >= 0) {
                    this.enableComponents();
                }
            } else if (e.getSource() instanceof CertPanel) {
                this.save((CertPanel)e.getSource());
            }
            super.stateChanged(e);
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
    }

    @Override
    protected void enableComponents() {
        int mixType;
        boolean enable = this.getConfiguration() != null ? (mixType = this.getConfiguration().getMixType()) != 1 && (!this.getConfiguration().isAutoConfigurationAllowed() || this.getConfiguration().isFallbackEnabled()) : true;
        this.enableCert(enable);
        this.setEnabled(enable);
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

