/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;

public class SizeRequirements
implements Serializable {
    public int minimum;
    public int preferred;
    public int maximum;
    public float alignment;

    public SizeRequirements() {
        this.minimum = 0;
        this.preferred = 0;
        this.maximum = 0;
        this.alignment = 0.5f;
    }

    public SizeRequirements(int n, int n2, int n3, float f) {
        this.minimum = n;
        this.preferred = n2;
        this.maximum = n3;
        this.alignment = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
    }

    public static int[] adjustSizes(int n, SizeRequirements[] sizeRequirementsArray) {
        return new int[0];
    }

    public static void calculateAlignedPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        int n2 = (int)((float)n * sizeRequirements.alignment);
        int n3 = n - n2;
        int n4 = 0;
        while (n4 < sizeRequirementsArray.length) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[n4];
            int n5 = (int)((float)sizeRequirements2.maximum * sizeRequirements2.alignment);
            int n6 = sizeRequirements2.maximum - n5;
            int n7 = Math.min(n2, n5);
            int n8 = Math.min(n3, n6);
            nArray[n4] = n2 - n7;
            nArray2[n4] = (int)Math.min((long)n7 + (long)n8, Integer.MAX_VALUE);
            ++n4;
        }
    }

    public static void calculateTiledPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        while (n2 < sizeRequirementsArray.length) {
            l += (long)sizeRequirementsArray[n2].minimum;
            l2 += (long)sizeRequirementsArray[n2].preferred;
            l3 += (long)sizeRequirementsArray[n2].maximum;
            ++n2;
        }
        if ((long)n >= l2) {
            SizeRequirements.expandedTile(n, l, l2, l3, sizeRequirementsArray, nArray, nArray2);
        } else {
            SizeRequirements.compressedTile(n, l, l2, l3, sizeRequirementsArray, nArray, nArray2);
        }
    }

    private static void compressedTile(int n, long l, long l2, long l3, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        float f = Math.min(l2 - (long)n, l2 - l);
        float f2 = l2 - l == 0L ? 0.0f : f / (float)(l2 - l);
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray[n3] = n2;
            SizeRequirements sizeRequirements = sizeRequirementsArray[n3];
            int n4 = (int)(f2 * (float)(sizeRequirements.preferred - sizeRequirements.minimum));
            nArray2[n3] = sizeRequirements.preferred - n4;
            n2 = (int)Math.min((long)n2 + (long)nArray2[n3], Integer.MAX_VALUE);
            ++n3;
        }
    }

    private static void expandedTile(int n, long l, long l2, long l3, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        float f = Math.min((long)n - l2, l3 - l2);
        float f2 = l3 - l2 == 0L ? 0.0f : f / (float)(l3 - l2);
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray[n3] = n2;
            SizeRequirements sizeRequirements = sizeRequirementsArray[n3];
            int n4 = (int)(f2 * (float)(sizeRequirements.maximum - sizeRequirements.preferred));
            nArray2[n3] = (int)Math.min((long)sizeRequirements.preferred + (long)n4, Integer.MAX_VALUE);
            n2 = (int)Math.min((long)n2 + (long)nArray2[n3], Integer.MAX_VALUE);
            ++n3;
        }
    }

    public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        int n;
        int n2;
        SizeRequirements sizeRequirements = new SizeRequirements();
        SizeRequirements sizeRequirements2 = new SizeRequirements();
        int n3 = 0;
        while (n3 < sizeRequirementsArray.length) {
            SizeRequirements sizeRequirements3 = sizeRequirementsArray[n3];
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.minimum);
            n = sizeRequirements3.minimum - n2;
            sizeRequirements.minimum = Math.max(n2, sizeRequirements.minimum);
            sizeRequirements2.minimum = Math.max(n, sizeRequirements2.minimum);
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.preferred);
            n = sizeRequirements3.preferred - n2;
            sizeRequirements.preferred = Math.max(n2, sizeRequirements.preferred);
            sizeRequirements2.preferred = Math.max(n, sizeRequirements2.preferred);
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.maximum);
            n = sizeRequirements3.maximum - n2;
            sizeRequirements.maximum = Math.max(n2, sizeRequirements.maximum);
            sizeRequirements2.maximum = Math.max(n, sizeRequirements2.maximum);
            ++n3;
        }
        int n4 = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
        n2 = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
        n = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
        float f = 0.0f;
        if (n4 > 0) {
            f = (float)sizeRequirements.minimum / (float)n4;
            f = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        }
        return new SizeRequirements(n4, n2, n, f);
    }

    public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements sizeRequirements = new SizeRequirements();
        int n = 0;
        while (n < sizeRequirementsArray.length) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[n];
            sizeRequirements.minimum = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
            sizeRequirements.preferred = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
            sizeRequirements.maximum = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
            ++n;
        }
        return sizeRequirements;
    }

    public String toString() {
        return "[" + this.minimum + "," + this.preferred + "," + this.maximum + "]@" + this.alignment;
    }
}

